% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/retrieve.R
\name{sf_retrieve}
\alias{sf_retrieve}
\title{Retrieve Records By Id}
\usage{
sf_retrieve(
  ids,
  fields,
  object_name,
  api_type = c("REST", "SOAP", "Bulk 1.0", "Bulk 2.0"),
  guess_types = TRUE,
  control = list(...),
  ...,
  verbose = FALSE
)
}
\arguments{
\item{ids}{\code{vector}, \code{matrix}, \code{data.frame}, or
\code{tbl_df}; if not a vector, there must be a column called Id (case
insensitive) that can be passed in the request.}

\item{fields}{\code{character}; one or more strings indicating the fields to be returned
on the records}

\item{object_name}{\code{character}; the name of the Salesforce object that the
function is operating against (e.g. "Account", "Contact", "CustomObject__c").}

\item{api_type}{\code{character}; one of \code{"REST"}, \code{"SOAP"},
\code{"Bulk 1.0"}, or \code{"Bulk 2.0"} indicating which API to use when
making the request.}

\item{guess_types}{\code{logical}; indicating whether or not to use \code{col_guess()}
to try and cast the data returned in the recordset. If \code{TRUE} then
\code{col_guess()} is used, if \code{FALSE} then all fields will be returned
as character. This is helpful when \code{col_guess()} will mangle field values
in Salesforce that you'd like to preserve during translation into a \code{tbl_df},
like numeric looking values that must be preserved as strings ("48.0").}

\item{control}{\code{list}; a list of parameters for controlling the behavior of
the API call being used. For more information of what parameters are available
look at the documentation for \code{\link{sf_control}}.}

\item{...}{arguments passed to \code{\link{sf_control}}}

\item{verbose}{\code{logical}; an indicator of whether to print additional
detail for each API call, which is useful for debugging. More specifically, when
set to \code{TRUE} the URL, header, and body will be printed for each request,
along with additional diagnostic information where available.}
}
\value{
\code{tibble}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Retrieves one or more new records to your organization’s data.
}
\examples{
\dontrun{
n <- 3
new_contacts <- tibble(FirstName = rep("Test", n),
                       LastName = paste0("Contact", 1:n))
new_contacts_result <- sf_create(new_contacts, object_name="Contact")
retrieved_records <- sf_retrieve(ids=new_contacts_result$id,
                                 fields=c("LastName"),
                                 object_name="Contact")
}
}
