% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psm.R
\name{psm}
\alias{psm}
\title{Compute the Pairwise Similarity Matrix}
\usage{
psm(x, parallel = TRUE)
}
\arguments{
\item{x}{A \code{B}-by-\code{n} matrix, where each of the \code{B} rows
represents a clustering of \code{n} items using cluster labels. For
clustering \code{b}, items \code{i} and \code{j} are in the same cluster if
\code{x[b,i] == x[b,j]}.}

\item{parallel}{Should the computation use all CPU cores?}
}
\value{
A \code{n}-by-\code{n} symmetric matrix whose \code{(i,j)} element
  gives the estimated expected number of times that items \code{i} and
  \code{j} are in the same subset (i.e., cluster or feature) based on the
  frequencies from the supplied clusterings or feature allocations.
}
\description{
This function computes the \code{n}-by-\code{n} matrix whose \code{(i,j)}
element gives the (estimated) probability that items \code{i} and \code{j}
are in the same subset (i.e., cluster).
}
\examples{
dim(iris.clusterings)
# Use 'parallel=FALSE' per CRAN rules for examples but, in practice, omit this.
probs <- psm(iris.clusterings, parallel=FALSE)
dim(probs)
probs[1:6, 1:6]

}
