% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chips.R
\name{threshold}
\alias{threshold}
\title{Threshold CHIPS Output}
\usage{
threshold(chipsOutput, threshold, ...)
}
\arguments{
\item{chipsOutput}{Output from the \code{chips} function.}

\item{threshold}{The minimum marginal probability for the subpartition.
Values closer to 1.0 will yield a partition of fewer items and values
closer to 0.0 will yield a partition of more items.}

\item{...}{Other arguments passed to the \code{chips} function.}
}
\value{
A list containing the same values as the \code{chips} function.
}
\description{
This function applies a threshold to the output of the \code{chips} function to find a CHIPS subpartition which achieves the specified \code{threshold} and then completes the partition using the SALSO algorithm.
}
\examples{
# For examples, use 'nCores = 1' per CRAN rules, but in practice omit this.
data(iris.clusterings)
draws <- iris.clusterings

all <- chips(draws, nRuns = 1, nCores = 1)
plot(all$n_items, all$probability)

threshold(all, threshold = 0.5, nCores = 1)

}
