# samc 1.2.1

- Fixed a regression in v1.2.0 where the samc() function would not work corectly unless matrix/raster layers contained at least one NA cell
- Revamped the automated test suite with more test scenarios to better catch issues before release
- Added checks during samc-class creation to prevent potential issues with discontinuous/clumped input data. Currently, this type of data will not work with the cond_passage() function, but will in a future release.
- Reworked some of the vignettes to produce cleaner pages and remove suggested dependencies (e.g. gifski, gganimate, ggplot2) from the package so that users aren't bugged about installing them if they don't need them.


# samc 1.2.0

- Added the ability to create samc-class objects from a custom P matrix using p_mat parameter in samc(). See the samc() documentation for details
- Added the cond_passage() function, which calculates conditional mean first passage times
- Added the locate() function, which functions similarly to the cellFromXY() function in the raster package. It's used to get cell numbers from xy coords, but unlike cellFromXY(), it properly accounts for how cells are numbered when the P matrix is constructed.
- Adjusted the absorption inputs to support values of 0 (i.e., no absorption). Currently, at least one cell must have a non-zero value
- Fixed an issue where raster/matrix inputs containing isolated cells (individual cells neighbored by only NA values) would lead to malformed P matrices.


# samc 1.1.0

- Added support for the use vectors of time steps in most short-term metrics. It is more computationally efficient and ergonomic to do this rather than calculating short-term metrics for each individual time step. Some key points:
  - When vector inputs are used for time steps, the result is contained in a list
  - The names of the entries in the list are character versions of the corresponding time step values
  - Time step vectors must consist of ordered positive integers with no duplicate values
  - Time step vector inputs have not been added for short-term metrics that return dense matrices
- Updated the map() function to support list inputs generated by the short-term metrics. The result is a list of RasterLayers
- Updated the *Temporal Analysis* and *Animations* vignettes to incorporate time step vectors
- Created a [Gitter community](https://gitter.im/samc-package/community) for package support. Gitter badges on the README and home pages can be used to access it.
- Updated the package citation info to refer to Marx et al. (2020, DOI: [10.1111/ecog.04891](https://doi.org/10.1111/ecog.04891))


# samc 1.0.4

- Add conditional usage of suggested packages in vignettes
- Minor updates for package info


# samc 1.0.3

- First CRAN submission


# samc 1.0.0

- Complete package rewrite (code dependent on v0.1.0 will not work)
- samc-class for managing SAMC data
- Utility functions for creating samc-class objects, checking inputs, and mapping data
- Heavily optimized analytical functions for all metrics described in Fletcher et al. (2019, DOI: [10.1111/ele.13333](https://doi.org/10.1111/ele.13333))
  - Utilizing sparse matrices
  - Eigen C++ implementation via Rcpp and RcppEigen
- Updated example data
- Extensive documentation
- Several tutorials


# samc 0.1.0

- Created crude functions for calculating metrics in Fletcher et al. (2019, DOI: [10.1111/ele.13333](https://doi.org/10.1111/ele.13333))
- Included example data
