% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0-parent-children.R
\name{similar_number}
\alias{similar_number}
\title{Numeric similarity comparison class}
\usage{
similar_number(scores, summary, methods, list_names, raw_values, digits = 3)
}
\arguments{
\item{scores}{List of similarity scores per method and comparison}

\item{summary}{Summary statistics by method and comparison}

\item{methods}{Character vector of methods used for comparison}

\item{list_names}{Character vector of names for the compared lists}

\item{raw_values}{List of raw numeric values being compared}

\item{digits}{Number of digits to round results (default: 3)}
}
\value{
An object of class "similar_number" (which inherits from "similar") containing:
\itemize{
\item scores: List of numeric similarity scores per method and comparison
\item summary: Summary statistics by method and comparison
\item methods: Character vector of numeric comparison methods used (exact, percent, normalized, fuzzy, exp, raw)
\item list_names: Character vector of names for the compared numeric lists
\item digits: Number of digits to round results in output
\item raw_values: List of raw numeric values that were compared
}
The numeric similarity scores are normalized values between 0 and 1, where 1 indicates
identical numbers and 0 indicates maximally different numbers based on the specific method used.
The exception is the "raw" method, which returns the absolute difference between values.
}
\description{
\code{similar_number} is an S3 class for numeric similarity comparisons.
}
\details{
This class extends the \code{similar} class and implements
numeric data-specific similarity comparison methods.
}
