% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rpro.R
\name{rpro}
\alias{rpro}
\title{Calculate proportion and margin of error (simple random sample)}
\usage{
rpro(df, col_name, ci = 95, na = "", N = 0)
}
\arguments{
\item{df}{object containing data frame on which to perform analysis (e.g. data)}

\item{col_name}{variable in data frame for which you want to calculate proportion and margin of error}

\item{ci}{(optional) confidence level for establishing a confidence interval using z-score (defaults to 95; restricted to 80, 85, 90, 95 or 99 as input)}

\item{na}{(optional) value that you want to filter and exclude (defaults to include everything)}

\item{N}{(optional) population universe (e.g. 10000, nrow(df)); if N value is passed as an argument, margin of error will be calculated using fpc}
}
\value{
Returns table of responses (n), proportions, margins of error, lower and upper bounds by factor for a given variable
}
\description{
Calculate proportion and margin of error (simple random sample)
}
\examples{
rpro(df=opening, col_name=openTime, ci=95, na="n/a", N=5361)
}
\references{
[1] Sampling Design & Analysis, S. Lohr, 1999, Equation 2.15
}
