% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssamp.R
\name{ssamp}
\alias{ssamp}
\title{Draws stratifed sample without replacement using proportional allocation}
\usage{
ssamp(df, n, strata, over = 1)
}
\arguments{
\item{df}{object containing full sampling data frame (e.g. data)}

\item{n}{sample size (integer) or object containing sample size}

\item{strata}{variable in sampling data frame by which to stratify (e.g. region)}

\item{over}{(optional) desired oversampling proportion (defaults to 0; takes value between 0 and 1 as input)}
}
\value{
Returns stratified sample without replacement
}
\description{
Draws stratifed sample without replacement using proportional allocation
}
\examples{
ssamp(df=albania, n=360, strata=qarku, over=0.1)

size <- rsampcalc(nrow(albania), 3, 95, 0.5)
stratifiedsample <- ssamp(albania, size, qarku)
}
\references{
Simplified wrapper around splitstackshape::stratified()
}
