% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{clusterTrace}
\alias{clusterTrace}
\title{Plot Traces of Cluster Sizes}
\usage{
clusterTrace(
  partitions,
  plot.cols = rep("black", ncol(partitions)),
  plot.title = ""
)
}
\arguments{
\item{partitions}{A matrix, with each row a numeric vector cluster labels}

\item{plot.cols}{A character vector of valid color names, whose length
represents the maximum number of stacked traces to be plotted}

\item{plot.title}{A character string to be used as the main title on the
trace plot}
}
\description{
Plot Traces of Cluster Sizes
}
\examples{

# Neal (2000) model and data
nealData <- c(-1.48, -1.40, -1.16, -1.08, -1.02, 0.14, 0.51, 0.53, 0.78)
mkLogPosteriorPredictiveDensity <- function(data = nealData,
                                            sigma2 = 0.1^2,
                                            mu0 = 0,
                                            sigma02 = 1) {
  function(i, subset) {
    posteriorVariance <- 1 / ( 1/sigma02 + length(subset)/sigma2 )
    posteriorMean <- posteriorVariance * ( mu0/sigma02 + sum(data[subset])/sigma2 )
    posteriorPredictiveSD <- sqrt(posteriorVariance + sigma2)
    dnorm(data[i], posteriorMean, posteriorPredictiveSD, log=TRUE)
  }
}

logPostPredict <- mkLogPosteriorPredictiveDensity()

nSamples <- 500L
partitions <- matrix(0, nrow=nSamples, ncol=length(nealData))
for ( i in 2:nSamples ) {
  partitions[i,] <- nealAlgorithm3(partitions[i-1,], logPostPredict, mass = 1.0, nUpdates = 2)
}

clusterTrace(partitions, plot.title = "Neal (2000) Data")
}
