% Generated by roxygen2 (4.0.2): do not edit by hand
\name{plotSapsScoreDensity}
\alias{plotSapsScoreDensity}
\title{Draw density plot of \code{saps_score} values for random gene sets}
\usage{
plotSapsScoreDensity(geneset, ...)
}
\arguments{
\item{geneset}{A geneset as returned by \code{\link{saps}}.}

\item{...}{Additional arguments to be passed to \code{\link{plot}}}
}
\description{
This function retrieves the \code{saps_score} values for the
    random gene sets generated during the computation of \code{saps_qvalue} for
    a given gene set. These are drawn as a density plot, with the value of
    \code{saps_score} for the gene set indicated.
}
\examples{
# 25 patients, none lost to followup
followup <- rep(1, 25)

# first 5 patients have good survival (in days)
time <- c(25, 27, 24, 21, 26, sample(1:3, 20, TRUE))*365

# create data for 100 genes, 25 patients
dat <- matrix(rnorm(25*100), nrow=25, ncol=100)
colnames(dat) <- as.character(1:100)

# create two random genesets of 5 genes each
set1 <- sample(colnames(dat), 5)
set2 <- sample(colnames(dat), 5)

genesets <- rbind(set1, set2)

# increase expression levels for set1 for first 5 patients
dat[1:5, set1] <- dat[1:5, set1]+10

# run saps and compute q-values
\dontrun{
results <- saps(genesets, dat, time, followup, random.samples=100,
               compute_qvalue=TRUE, qvalue.samples=10)

set <- results$genesets[["set1"]]

# qvalue.samples=10 is too small to achieve significance
plotSapsScoreDensity(set)
}
}
\seealso{
\code{\link{saps}} \code{\link{calculateQValue}}
}

