% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.snowprofileSet.R
\name{plot.snowprofileSet}
\alias{plot.snowprofileSet}
\title{Plot a single layer property in multiple profiles side-by-side}
\usage{
\method{plot}{snowprofileSet}(
  x,
  SortMethod = "time",
  ColParam = "gtype",
  TopDown = FALSE,
  DateStart = NA,
  DateEnd = NA,
  ylim = NULL,
  OutlineLyrs = FALSE,
  HorizGrid = TRUE,
  main = NA,
  ylab = NA,
  xlab = NA,
  box = TRUE,
  labelOriginalIndices = FALSE,
  yPadding = 10,
  xPadding = 0.5,
  ...
)
}
\arguments{
\item{x}{An object of class \link{snowprofileSet}}

\item{SortMethod}{How to arrange profiles along the x-axis. Options include timeseries (default = 'time'), in existing order of Profiles list ('unsorted'), sorted by HS ('hs'), or elevation ('elev')}

\item{ColParam}{What parameter to show with colour. So far the following types are available: graintype (default), hardness, temperature, density, grainsize.}

\item{TopDown}{Option to plot by depth instead of height with zero depth on top of plot (default = FALSE)}

\item{DateStart}{Start date for timeseries plots (\code{SortMethod = 'time'}). If not provided, the function takes the date range from Profiles (default = NA).}

\item{DateEnd}{End date for timeseries plots (\code{SortMethod = 'time'}). If not provided, the function takes the date range from Profiles (default = NA).}

\item{ylim}{Vertical range of plot}

\item{OutlineLyrs}{Switch for outlining layers (default = FALSE)}

\item{HorizGrid}{Draw horizontal grid at layer heights (default = TRUE)}

\item{main}{Main title}

\item{ylab}{y-axis label; disable ylab by providing an empty string (i.e., ylab = '')}

\item{xlab}{x-axis label; disable xlab by providing an empty string (i.e., xlab = '')}

\item{box}{Draw a box around the plot (default = TRUE)}

\item{labelOriginalIndices}{Label the original (i.e. prior to sorting) indices of the profiles at the x-axis? (default = FALSE)}

\item{yPadding}{Padding between ylim and limits of data, default = 10.
Note that R will still put padding by default. If you want to prohibit that entirely, specify \code{xaxs ='i'}, or \code{yaxs = 'i'}.}

\item{xPadding}{Padding between xlim and limits of data, default = 0.5.
Note that R will still put padding by default. If you want to prohibit that entirely, specify \code{xaxs = 'i'}, or \code{yaxs = 'i'}.}

\item{...}{Additional parameters passed to plot()}
}
\description{
A flexible function to plot multiple snowprofiles either in a timeseries or various types of groups
}
\examples{

## Standard profile timeline (e.g. https://niviz.org)
plot(SPtimeline)

## Group of profiles with same timestamp
plot(SPgroup, SortMethod = 'unsorted')  # sorted in same order as list
plot(SPgroup, SortMethod = 'hs') # sorted by snow height
plot(SPgroup, SortMethod = 'elev') # sorted by elevation

## Colour layers by other properties
plot(SPtimeline, ColParam = 'density')

## Align layers by depth instead of height
plot(SPtimeline, TopDown = TRUE)

## Timelines with specific date ranges
plot(SPtimeline, DateEnd = '2017-12-17')
plot(SPtimeline, DateStart = '2017-12-15', DateEnd = '2017-12-17')

## Additional examples of plot dimensions and labelling
## Label the indices of the profiles in the list:
plot(SPgroup, SortMethod = 'elev', labelOriginalIndices = TRUE)
##  ... and with minimized axis limits:
plot(SPgroup, SortMethod = 'elev', labelOriginalIndices = TRUE,
       yPadding = 0, xPadding = 0, xaxs = 'i', yaxs = 'i')
##  sorted by depth, and without box:
plot(SPgroup, SortMethod = 'hs', TopDown = TRUE, box = FALSE)

}
\seealso{
\link{plot.snowprofile}, \link{SPgroup}
}
\author{
shorton, fherla, phaegeli
}
