% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/snowprofileLayers.R
\name{snowprofileLayers}
\alias{snowprofileLayers}
\title{High-level constructor for a snowprofileLayers object}
\usage{
snowprofileLayers(
  height = as.double(NA),
  temperature = as.double(NA),
  density = as.double(NA),
  lwc = as.double(NA),
  gsize = as.double(NA),
  gsize_max = as.double(NA),
  gsize_avg = as.double(NA),
  gtype = as.factor(NA),
  gtype_sec = as.factor(NA),
  hardness = as.double(NA),
  ddate = as.POSIXct(NA),
  bdate = as.Date(NA),
  ssi = as.double(NA),
  ...,
  hs = as.double(NA),
  formatTarget = "all",
  layerFrame = NA,
  validate = TRUE,
  dropNAs = TRUE
)
}
\arguments{
\item{height}{height vector (cm)}

\item{temperature}{snow temperature (deg C)}

\item{density}{layer density (kg/m3)}

\item{lwc}{liquid water content (\%)}

\item{gsize}{grain size (mm)}

\item{gsize_max}{maximum grain size (mm)}

\item{gsize_avg}{average grain size (mm)}

\item{gtype}{grain type (character or factor)}

\item{gtype_sec}{secondary grain type (character or factor)}

\item{hardness}{numeric hand hardness (use \link{char2numHHI} to convert from character hardness)}

\item{ddate}{deposition date of layer (POSIXct format)}

\item{bdate}{burial date of layer (Date format)}

\item{ssi}{snow stability index (numeric)}

\item{...}{columns to include in the layers object. Note, that they need to correspond to the according height/depth array.
e.g. hardness (can use character hardness or numeric hardness via \link{char2numHHI}), ddate (class POSIX), bdate (class Date) gtype (character or factor), density, temperature, gsize, lwc, gsize_max, gtype_sec, ssi, depth, thickness}

\item{hs}{total snow height (cm), if not deductible from height or depth & thickness vector}

\item{formatTarget}{string indicating which layer characteristics should be auto-filled, e.g. 'all' (default), 'height', 'depth', 'thickness', 'none'}

\item{layerFrame}{a data.frame that's converted to a snowprofileLayers class if no other layer characteristics are provided}

\item{validate}{Validate \code{obj} with \link{validate_snowprofileLayers}?}

\item{dropNAs}{Do you want to drop all columns consisting of NAs only?}
}
\value{
snowprofileLayers object as data.frame with strings as factors
}
\description{
Helper function to conveniently create a snowprofileLayers object, i.e. data.frame with mandatory column fields height (or depth) that provides vertical position of layers.
Layers need to be ordered in an ascending manner, i.e. last row corresponds to snow surface. If only depth is given, the layer thickness of the lowermost
layer will be set to a default value (100 cm) to be able to convert to height (i.e. important for subsequent package routines). If the columns are not of equal
lengths, their values will be recycled (default data.frame mechanism), but a warning will be issued. Certain columns will be auto-filled
(\link{format_snowprofileLayers}). Instead of individual layer characteristics, a data.frame can be provided, which will be converted into a snowprofileLayers class.
Calls low-level constructor \link{new_snowprofileLayers} and asserts correctness through a call to \link{validate_snowprofileLayers}.
}
\examples{

## Empty layers object:
snowprofileLayers(dropNAs = FALSE)


## convert and recycle character hardness (i.e., warning issued):
snowprofileLayers(height = c(10, 25, 50),
                  hardness = char2numHHI('1F+'),
                  gtype = c('FC', NA, 'PP'))


## create snowprofileLayers object from pre-existant data.frame:
df <- data.frame(height = c(10, 25, 50),
                  hardness = c(2, 3, 1),
                  gtype = c('FC', NA, 'PP'),
                  stringsAsFactors = TRUE)

snowprofileLayers(layerFrame = df)

}
\seealso{
\link{snowprofile}
}
\author{
shorton, fherla
}
