% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/snowprofilePrf.R
\name{snowprofilePrf}
\alias{snowprofilePrf}
\title{Construct snowprofile object from PRF file}
\usage{
snowprofilePrf(Filename, ProfileDate = NA, tz = "UTC")
}
\arguments{
\item{Filename}{path to prf file}

\item{ProfileDate}{read a single profile from file (default = NA will read all profiles)}

\item{tz}{time zone (default = 'UTC')}
}
\value{
a single snowprofile object of list of multiple snowprofile objects
}
\description{
Read .prf files from SNOWPACK model output
}
\details{
Several SNOWPACK model output formats exist see \href{https://models.slf.ch/docserver/snowpack/html/snowpackio.html}{SNOWPACK documentation}

Definitions of PRF files are provided at \href{https://models.slf.ch/docserver/snowpack/html/prf_format.html}{https://models.slf.ch/docserver/snowpack/html/prf_format.html}

PRF files typically contain profiles from the same station at multiple time steps. If a specific \code{ProfileDate} is provided a single snowprofile object is returned (search available dates with \code{scanProfileDates}), otherwise all profiles are read and a list of snowprofile objects is returned.
}
\examples{

## Path to example prf file
Filename <- system.file('extdata', 'example.prf', package = 'sarp.snowprofile')

## Scan dates in file
Dates <- scanProfileDates(Filename)
print(Dates)

## Read a single profile by date and plot
ProfileDate <- Dates[3]
Profile <- snowprofilePrf(Filename, ProfileDate = ProfileDate)
plot(Profile)

## Read entire time series and plot
Profiles <- snowprofilePrf(Filename)
plot(Profiles, main = 'Timeseries read from example.prf')

}
\seealso{
\link{snowprofilePro}, \link{scanProfileDates}, \link{snowprofileSno}
}
\author{
shorton
}
