% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SAWNUTI.R
\name{sawnuti}
\alias{sawnuti}
\title{Comparing Sequences with Non-Uniform Time Intervals}
\usage{
sawnuti(string1, string2, times1, times2, global = T, alpha,
match_function, gap_penalty)
}
\arguments{
\item{string1}{character. Character of representations of each element in the first sequence
separated by a single white space.}

\item{string2}{character. Character of representations of each element in the first sequence
separated by a single white space.}

\item{times1}{character. Numerical time values between each value in the first sequence.
Should be written as a single character string, where each value is separated by a single white
space.}

\item{times2}{character. Numerical time values between each value in the second sequence.
Should be written as a single character string, where each value is separated by a single white
space.}

\item{global}{logical. Logical representing whether a user wishes to perform a global or local
alignment.  T = global, F = local.}

\item{alpha}{double. Time interval penalty bias.  Weights the influence of time on the alignment
calculation.}

\item{match_function}{R function. Score given for alignment of particular values.  Must be able
to take in two values from the universe of possible events, and return a numerical score
for the alignment of those two elements.  Simplest is a constant score returned, can also be
implemented as a matrix look-up.}

\item{gap_penalty}{numerical. This implementation only allows for constant gap penalties.}
}
\value{
Vector containing 'similarity score', 'alignment', and 'scoring matrix'.
}
\description{
The SAWNUTI algorithm performs sequence comparison for finite
sequences of discrete events with non-uniform time intervals.  Further
description of the algorithm can be found in the paper:
A. Murph, A. Flynt, B. R. King (2021). Comparing finite sequences of discrete events with non-uniform time intervals, Sequential Analysis, 40(3), 291-313. <doi:10.1080/07474946.2021.1940491>.
}
\details{
Zero-one scale of all time values in the entire dataset is assumed before calculation.
See Examples for possible formatting of the match_function.
}
\section{PREPROCESSING ASSUMPTION}{

Zero-one scale of all time values in the entire dataset is assumed before calculation.  Since
this preprocessing step must be done with ALL possible time intervals, it cannot be done in
this alignment which only takes in two particular observations.
}

\examples{
matchFunction = function(a,b){ifelse(a==b, 1, -1)}

sawnuti(string1="a b c", string2="d b c", times1="1 2 3", 
times2="3 2 1", alpha = 1, match_function = matchFunction, gap_penalty = 1)
}
\references{
A. Murph, A. Flynt, B. R. King (2021). Comparing finite sequences of discrete events with non-uniform time intervals, Sequential Analysis, 40(3), 291-313.
}
