% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sbpiper_pe.r
\name{sbpiper_pe}
\alias{sbpiper_pe}
\title{Main R function for SBpipe pipeline: parameter_estimation().}
\usage{
sbpiper_pe(model, finalfits_filenamein, allfits_filenamein, plots_dir,
  data_point_num,
  fileout_param_estim_best_fits_details = "param_estim_best_fits_details.csv",
  fileout_param_estim_details = "param_estim_details.csv",
  fileout_param_estim_summary = "param_estim_summary.csv",
  best_fits_percent = 50, plot_2d_66cl_corr = TRUE,
  plot_2d_95cl_corr = TRUE, plot_2d_99cl_corr = TRUE, logspace = TRUE,
  scientific_notation = TRUE)
}
\arguments{
\item{model}{the name of the model}

\item{finalfits_filenamein}{the dataset containing the best parameter fits}

\item{allfits_filenamein}{the dataset containing all the parameter fits}

\item{plots_dir}{the directory to save the generated plots.}

\item{data_point_num}{the number of data points used for parameterise the model.}

\item{fileout_param_estim_best_fits_details}{the name of the file for the statistics of the parameters best fits.}

\item{fileout_param_estim_details}{the name of the file containing the detailed statistics for the estimated parameters.}

\item{fileout_param_estim_summary}{the name of the file containing the summary for the parameter estimation.}

\item{best_fits_percent}{the percent of best fits to analyse.}

\item{plot_2d_66cl_corr}{true if the 2D parameter correlation plots for 66\% confidence intervals should be plotted.}

\item{plot_2d_95cl_corr}{true if the 2D parameter correlation plots for 95\% confidence intervals should be plotted.}

\item{plot_2d_99cl_corr}{true if the 2D parameter correlation plots for 99\% confidence intervals should be plotted.}

\item{logspace}{true if parameters should be plotted in logspace.}

\item{scientific_notation}{true if axis labels should be plotted in scientific notation.}
}
\description{
Main R function for SBpipe pipeline: parameter_estimation().
}
\examples{
\donttest{
dir.create(file.path("pe_datasets"))
dir.create(file.path("pe_plots"))
data(insulin_receptor_best_fits)
write.table(insulin_receptor_best_fits, 
            file=file.path("pe_datasets", "best_fits.csv"), 
            row.names=FALSE)
data(insulin_receptor_all_fits)
write.table(insulin_receptor_all_fits, 
            file=file.path("pe_datasets", "all_fits.csv"), 
            row.names=FALSE)
sbpiper_pe(model="ir_beta", 
           finalfits_filenamein=file.path("pe_datasets", "best_fits.csv"), 
           allfits_filenamein=file.path("pe_datasets", "all_fits.csv"), 
           plots_dir="pe_plots", 
           data_point_num=33, 
           fileout_param_estim_best_fits_details=file.path("pe_datasets", 
                                                 "param_estim_best_fits_details.csv"), 
           fileout_param_estim_details=file.path("pe_datasets", 
                                                 "param_estim_details.csv"), 
           fileout_param_estim_summary=file.path("pe_datasets", 
                                                 "param_estim_summary.csv"), 
           best_fits_percent=50, 
           plot_2d_66cl_corr=TRUE, 
           plot_2d_95cl_corr=TRUE, 
           plot_2d_99cl_corr=TRUE, 
           logspace=TRUE, 
           scientific_notation=TRUE)
}
}
