% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sbpiper_pe.r
\name{objval_vs_iters_analysis}
\alias{objval_vs_iters_analysis}
\title{Analysis of the Objective values vs Iterations.}
\usage{
objval_vs_iters_analysis(model, filename, plots_dir)
}
\arguments{
\item{model}{the model name}

\item{filename}{the filename containing the fits sequence}

\item{plots_dir}{the directory to save the generated plots}
}
\description{
Analysis of the Objective values vs Iterations.
}
\examples{
dir.create(file.path("pe_datasets"))
dir.create(file.path("pe_plots"))
data(insulin_receptor_all_fits)
colnames(insulin_receptor_all_fits)[1] <- "ObjVal"
write.table(insulin_receptor_all_fits, 
            file=file.path("pe_datasets", "all_fits.csv"), 
            row.names=FALSE)
objval_vs_iters_analysis(model="model", 
                         filename=file.path("pe_datasets", "all_fits.csv"), 
                         plots_dir="pe_plots")
}
