% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/item_upload_files.R
\name{item_upload_cloud}
\alias{item_upload_cloud}
\title{Upload File to Item Cloud Storage}
\usage{
item_upload_cloud(
  sb_id,
  files,
  ...,
  status = TRUE,
  session = current_session()
)
}
\arguments{
\item{sb_id}{An \code{\link{sbitem}} object or a character ScienceBase ID corresponding to the item}

\item{files}{A string vector of paths to files to be uploaded}

\item{...}{Additional parameters are passed on to \code{\link[httr]{GET}}, \code{\link[httr]{POST}},
\code{\link[httr]{HEAD}}, \code{\link[httr]{PUT}}, or \code{\link[httr]{DELETE}}}

\item{status}{logical display upload status?}

\item{session}{Session object from \code{\link{authenticate_sb}}. Defaults to anonymous or 
last authenticated session}
}
\value{
Success message invisibly. NOTE: cloud processing
can take some time so the added file may not appear immediately. 
For this reason, a sciencebase item json is NOT returned as is
done with other similar functions.
}
\description{
Adds a file to an item in cloud storage
}
\examples{
\dontrun{
res <- item_create(user_id(), "testing 123")
cat("foo bar", file = "foobar.txt")
item_append_files(res$id, "foobar.txt")
}
}
