% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/session_details.R
\name{session_details}
\alias{session_details}
\title{Get session info}
\usage{
session_details(..., session = current_session())
}
\arguments{
\item{...}{Additional parameters are passed on to \code{\link[httr]{GET}}}

\item{session}{SB session object from \code{\link{authenticate_sb}}}
}
\value{
list, if not logged in states that, but if logged in, user details
If logged in, will include a "jossoSessionId" that can be used for 
authenticated file downloads by appending josso={'jossoSessionId'} to the 
url for the file requiring authentication. This is helpful when passing
a url to a library that will handle the download of a remote file automatically 
such as jsonlite::readJSON or readr::read_csv.
}
\description{
Get the details associated with current ScienceBase user session.
}
\examples{
\dontrun{

session_details()
 
# If logged in, can use jossoSessionId for downloads.
authenticate_sb()

temp_json <- tempfile(fileext = ".json")

jsonlite::write_json(list(test = "test"), temp_json)

item <- item_upload_create(sbtools::user_id(), temp_json)

token <- session_details()$jossoSessionId

(base_url <- item$file[[1]]$downloadUri)

# will fail
try(jsonlite::read_json(base_url))

url <- paste0(base_url, "&josso=", token)

jsonlite::read_json(url)

item_rm(item$id)

}
}
