% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sb_item.R
\name{sbitem}
\alias{sbitem}
\alias{as.sbitem}
\alias{as.sbitem.default}
\alias{is.sbitem}
\title{ScienceBase item class}
\usage{
as.sbitem(x, ...)

\method{as.sbitem}{default}(x, ...)

is.sbitem(x)
}
\arguments{
\item{x}{Input, variety of things, character, list, or sbitem class 
object}

\item{...}{Further args passed on to \code{\link{item_get}}, only in 
the method for character class inputs}
}
\description{
ScienceBase item class
}
\examples{
\donttest{
# Single item from item_get()
item_get("57976a0ce4b021cadec97890")

# Get many w/ e.g., an lapply() call
library("httr")
res <- query_items(list(s = "Search", q = "water", format = "json"))
if(res$status == 200) {
  ids <- vapply(httr::content(res)$items, "[[", "", "id")
  (out <- lapply(ids[1:3], item_get))
}
# create item class from only an item ID
as.sbitem("5ebe92af82ce476925e44b8f")

# sbitem gives back itself
(x <- as.sbitem("5ebe92af82ce476925e44b8f"))
as.sbitem(x)
}
}
