% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/current_session.R
\name{session_renew}
\alias{session_renew}
\title{Checks current session and re-authenticates if necessary}
\usage{
session_renew(password, ..., username)
}
\arguments{
\item{password}{The password to use, if needed, to renew the session.}

\item{...}{Any additional parameters are currently ignored.}

\item{username}{Optional. Used only to confirm that the current username is 
what you expect; if you want to switch usernames, use 
\code{authenticate_sb()} instead of this function.}
}
\value{
Returns the session object.
}
\description{
Checks the state of your Sciencebase session, re-authenticates if the session
is expired, and simply renews if the session is active.
}
\examples{
\dontrun{
# an empty call is sufficient if the session is current, 
# but will break if haven't been logged in before
session_renew()

# include a password if session may be expired
session_renew('newpass')

# optionally confirm the value of the current username
session_renew(username='olduser@usgs.gov', 'newpass')
}
}
