% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_prop_associations.R
\name{plotDEheatmap_conos}
\alias{plotDEheatmap_conos}
\title{Plot a heatmap of differential genes. Code is adapted from Conos package.
https://github.com/kharchenkolab/conos/blob/master/R/plot.R}
\usage{
plotDEheatmap_conos(
  con,
  groups,
  container,
  de = NULL,
  min.auc = NULL,
  min.specificity = NULL,
  min.precision = NULL,
  n.genes.per.cluster = 10,
  additional.genes = NULL,
  exclude.genes = NULL,
  labeled.gene.subset = NULL,
  expression.quantile = 0.99,
  pal = (grDevices::colorRampPalette(c("dodgerblue1", "grey95", "indianred1")))(1024),
  ordering = "-AUC",
  column.metadata = NULL,
  show.gene.clusters = TRUE,
  remove.duplicates = TRUE,
  column.metadata.colors = NULL,
  show.cluster.legend = TRUE,
  show_heatmap_legend = FALSE,
  border = TRUE,
  return.details = FALSE,
  row.label.font.size = 10,
  order.clusters = FALSE,
  split = FALSE,
  split.gap = 0,
  cell.order = NULL,
  averaging.window = 0,
  ...
)
}
\arguments{
\item{con}{conos (or p2) object}

\item{groups}{groups in which the DE genes were determined (so that the cells can be ordered correctly)}

\item{container}{environment Project container that stores sub-containers
for each cell type as well as results and plots from all analyses}

\item{de}{differential expression result (list of data frames)}

\item{min.auc}{optional minimum AUC threshold}

\item{min.specificity}{optional minimum specificity threshold}

\item{min.precision}{optional minimum precision threshold}

\item{n.genes.per.cluster}{number of genes to show for each cluster}

\item{additional.genes}{optional additional genes to include (the genes will be assigned to the closest cluster)}

\item{exclude.genes}{an optional list of genes to exclude from the heatmap}

\item{labeled.gene.subset}{a subset of gene names to show (instead of all genes). Can be a vector of gene names, or a number of top genes (in each cluster) to show the names for.}

\item{expression.quantile}{expression quantile to show (0.98 by default)}

\item{pal}{palette to use for the main heatmap}

\item{ordering}{order by which the top DE genes (to be shown) are determined (default "-AUC")}

\item{column.metadata}{additional column metadata, passed either as a data.frame with rows named as cells, or as a list of named cell factors.}

\item{show.gene.clusters}{whether to show gene cluster color codes}

\item{remove.duplicates}{remove duplicated genes (leaving them in just one of the clusters)}

\item{column.metadata.colors}{a list of color specifications for additional column metadata, specified according to the HeatmapMetadata format. Use "clusters" slot to specify cluster colors.}

\item{show.cluster.legend}{whether to show the cluster legend}

\item{show_heatmap_legend}{whether to show the expression heatmap legend}

\item{border}{show borders around the heatmap and annotations}

\item{return.details}{if TRUE will return a list containing the heatmap (ha), but also raw matrix (x), expression list (expl) and other info to produce the heatmap on your own.}

\item{row.label.font.size}{font size for the row labels}

\item{order.clusters}{whether to re-order the clusters according to the similarity of the expression patterns (of the genes being shown)}

\item{split}{logical If TRUE splits the heatmap by cell type (default=FALSE)}

\item{split.gap}{numeric The distance to put in the gaps between split parts of the heatmap if split=TRUE (default=0)}

\item{cell.order}{explicitly supply cell order}

\item{averaging.window}{optional window averaging between neighboring cells within each group (turned off by default) - useful when very large number of cells shown (requires zoo package)}

\item{...}{extra parameters are passed to pheatmap}
}
\value{
ComplexHeatmap::Heatmap object (see return.details param for other output)
}
\description{
Plot a heatmap of differential genes. Code is adapted from Conos package.
https://github.com/kharchenkolab/conos/blob/master/R/plot.R
}
