% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{sclink_cor}
\alias{sclink_cor}
\title{Calculate scLink's correlation matrix}
\usage{
sclink_cor(expr, ncores, nthre = 20, dthre = 0.9)
}
\arguments{
\item{expr}{A gene expression matrix with rows representing cells and columns representing genes.
Gene names are given as column names. Can be the output of \code{sclink_norm} or user constructed gene
expression matrices.}

\item{ncores}{Number of cores if using parallel computation.}

\item{nthre}{An integer specifying a threshold on the number of complete observations.
Defaults to 20.}

\item{dthre}{A number specifying the threshold on dropout probabilities. Defaults to 0.9.}
}
\value{
A correlation matrix for gene co-expression relationships.
}
\description{
Calculate scLink's correlation matrix
}
\examples{
\donttest{
count = readRDS(system.file("extdata", "example.rds", package = "scLink"))
count.norm = sclink_norm(count, scale.factor = 1e6, filter.genes = TRUE, n = 500)
corr = sclink_cor(expr = count.norm, ncores = 1)
}
}
\author{
Wei Vivian Li, \email{vivian.li@rutgers.edu}
}
