% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pg_embedding.R
\name{pg_embedding}
\alias{pg_embedding}
\title{Co-embeddings of Peaks and Genes.}
\usage{
pg_embedding(
  gg_net,
  pp_net,
  pg_net_list,
  dirpath = tempdir(),
  relearn_pg_embedding = TRUE,
  save_file = TRUE,
  d = 100,
  numwalks = 5,
  walklength = 3,
  epochs = 100,
  neg_sample = 5,
  batch_size = 32,
  weighted = TRUE,
  exclude_pos = FALSE,
  seed = NULL,
  python_env = "scPOEM_env"
)
}
\arguments{
\item{gg_net}{The gene-gene network.}

\item{pp_net}{The peak-peak network.}

\item{pg_net_list}{A list of peak-gene networks, constructed via different methods.}

\item{dirpath}{The folder path to read or write file.}

\item{relearn_pg_embedding}{Logical. Whether to relearn the low-dimensional representations for peaks and genes from scratch. If FALSE, the function will attempt to read from \cr\code{node_embeddings.mtx}, \code{node_used_peak.csv}, \code{node_used_gene.csv} \cr under \code{dirpath/embedding} in single mode or \cr \code{dirpath/state_name/embedding} in compare mode.}

\item{save_file}{Logical, whether to save the output to a file.}

\item{d}{Dimension of the latent space. Default is 100.}

\item{numwalks}{Number of random walks per node. Default is 5.}

\item{walklength}{Length of walk depth. Default is 3.}

\item{epochs}{Number of training epochs. Default is 100.}

\item{neg_sample}{Number of negative samples per positive sample. Default is 5.}

\item{batch_size}{Batch size for training. Default is 32.}

\item{weighted}{Whether the sampling network is weighted. Default is TRUE.}

\item{exclude_pos}{Whether to exclude positive samples from negative sampling. Default is FALSE.}

\item{seed}{An integer specifying the random seed to ensure reproducible results.}

\item{python_env}{Name or path of the Python environment to be used.}
}
\value{
A list containing the following: \describe{
\item{\code{E}}{Low-dimensional representations of peaks and genes}
\item{\code{peak_node}}{Peak ids that are associated with other peaks or genes.}
\item{\code{gene_node}}{Gene ids that are associated with other peaks or genes.}
}
}
\description{
Learn the low-dimensional representations for peaks and genes with a meta-path based method.
}
\examples{
\donttest{
library(scPOEM)
library(monocle)
dirpath <- "./example_data"
# Download single mode example data
data(example_data_single)
gg_net <- GGN(example_data_single$Y,
              file.path(dirpath, "single"),
              save_file=FALSE)
pp_net <- PPN(example_data_single$X, example_data_single$peak_data,
              example_data_single$cell_data, example_data_single$genome,
              file.path(dirpath, "single"), save_file=FALSE)
net_Lasso <- PGN_Lasso(example_data_single$X, example_data_single$Y,
                       example_data_single$gene_data, example_data_single$neibor_peak,
                       file.path(dirpath, "single"), save_file=FALSE)
net_RF <- PGN_RF(example_data_single$X, example_data_single$Y,
                 example_data_single$gene_data, example_data_single$neibor_peak,
                 file.path(dirpath, "single"), save_file=FALSE)
net_XGB <- PGN_XGBoost(example_data_single$X, example_data_single$Y,
                       example_data_single$gene_data, example_data_single$neibor_peak,
                       file.path(dirpath, "single"), save_file=FALSE)
E_result <- pg_embedding(gg_net, pp_net, list(net_Lasso, net_RF, net_XGB),
                         file.path(dirpath, "single"), save_file=FALSE)
}

}
