% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SCALPEL_reviewNeurons.R
\name{updateThreshold}
\alias{updateThreshold}
\title{Review and update the chosen threshold for image segmentation in Step 1 of SCALPEL.}
\usage{
updateThreshold(step0Output)
}
\arguments{
\item{step0Output}{An object of class \code{scalpel} or \code{scalpelStep0}, which result from running the
\code{\link{scalpel}} or \code{\link{scalpelStep0}} functions, respectively.}
}
\value{
An object identical to \code{step0Output}, except it may (depending on the user's decision) have \code{lowThreshold} updated.
}
\description{
We plot random frames from the video processed in Step 0 of SCALPEL with shading to indicate the
smallest of the automatically chosen thresholds that will be used to perform image segmentation in
Step 1 of SCALPEL. The user is given the option to try out different thresholds and if desired, update
the threshold to use.
}
\examples{
\dontrun{
### many of the functions in this package are interconnected so the
### easiest way to learn to use the package is by working through the vignette,
### which is available at ajpete.com/software

#assumes you have run the example for the "scalpel" function

#update the smallest threshold used for image segmentation in Step 1
scalpelOutput = updateThreshold(step0Output = scalpelOutput)
}
}
\seealso{
\code{\link{scalpelStep0}}
}

