% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hplm.R, R/print.sc_hplm.R, R/export.sc_hplm.R,
%   R/coefficents.sc_plm.R
\name{hplm}
\alias{hplm}
\alias{print.sc_hplm}
\alias{export.sc_hplm}
\alias{coef.sc_hplm}
\title{Hierarchical piecewise linear model / piecewise regression}
\usage{
hplm(
  data,
  dvar,
  pvar,
  mvar,
  model = c("W", "H-M", "B&L-B", "JW"),
  contrast = c("first", "preceding"),
  contrast_level = NA,
  contrast_slope = NA,
  method = c("ML", "REML"),
  control = list(opt = "optim"),
  random.slopes = FALSE,
  lr.test = FALSE,
  ICC = TRUE,
  trend = TRUE,
  level = TRUE,
  slope = TRUE,
  random_trend = FALSE,
  random_level = FALSE,
  random_slope = FALSE,
  fixed = NULL,
  random = NULL,
  update.fixed = NULL,
  data.l2 = NULL,
  ...
)

\method{print}{sc_hplm}(x, digits = 3, ..., smd = FALSE, casewise = FALSE)

\method{export}{sc_hplm}(
  object,
  caption = NA,
  footnote = NA,
  filename = NA,
  kable_styling_options = list(),
  kable_options = list(),
  round = 2,
  nice = TRUE,
  casewise = FALSE,
  ...
)

\method{coef}{sc_hplm}(object, casewise = FALSE, ...)
}
\arguments{
\item{data}{A single-case data frame. See \code{\link[=scdf]{scdf()}} to learn about this
format.}

\item{dvar}{Character string with the name of the dependent variable.
Defaults to the attributes in the scdf file.}

\item{pvar}{Character string with the name of the phase variable. Defaults to
the attributes in the scdf file.}

\item{mvar}{Character string with the name of the measurement time variable.
Defaults to the attributes in the scdf file.}

\item{model}{Model used for calculating the dummy parameters (see Huitema &
McKean, 2000). Default is \code{model = "W"}. Possible values are: \code{"B&L-B"},
\code{"H-M"}, \code{"W"}, and deprecated \code{"JW"}.}

\item{contrast}{Sets contrast_level and contrast_slope. Either "first",
"preceding" or a contrast matrix.}

\item{contrast_level}{Either "first", "preceding" or a contrast matrix. If NA
contrast_level is a copy of contrast.}

\item{contrast_slope}{Either "first", "preceding" or a contrast matrix. If NA
contrast_level is a copy of contrast.}

\item{method}{Method used to fit your model. Pass \code{"REML"} to maximize the
restricted log-likelihood or \code{"ML"} for maximized log-likelihood. Default
is \code{"ML"}.}

\item{control}{A list of settings for the estimation algorithm, replacing the
default values passed to the function \code{lmeControl} of the \code{nlme} package.}

\item{random.slopes}{If \code{random.slopes = TRUE} random slope effects of the
level, trend, and treatment parameter are estimated.}

\item{lr.test}{If set TRUE likelihood ratio tests are calculated comparing
model with vs. without random slope parameters.}

\item{ICC}{If \code{ICC = TRUE} an intraclass-correlation is estimated.}

\item{trend}{A logical indicating if a trend parameters is included in the
model.}

\item{level}{A logical indicating if a level parameters is included in the
model.}

\item{slope}{A logical indicating if a slope parameters is included in the
model.}

\item{random_trend}{If TRUE, includes a random trend trend effect.}

\item{random_level}{If TRUE, includes a random level trend effect.}

\item{random_slope}{If TRUE, includes a random slope trend effect.}

\item{fixed}{Defaults to the fixed part of the standard piecewise regression
model. The parameter phase followed by the phase name (e.g., phaseB)
indicates the level effect of the corresponding phase. The parameter
'inter' followed by the phase name (e.g., interB) adresses the slope effect
based on the method provide in the model argument (e.g., "B&L-B"). The
formula can be changed for example to include further L1 or L2 variables
into the regression model.}

\item{random}{The random part of the model.}

\item{update.fixed}{An easier way to change the fixed model part
(e.g., \code{. ~ . + newvariable}).}

\item{data.l2}{A dataframe providing additional variables at Level 2. The
scdf File has to have names for all cases and the Level 2 dataframe has to
have a column named 'cases' with the names of the cases the Level 2
variables belong to.}

\item{...}{Further arguments passed to the lme function.}

\item{x}{An object returned by \code{\link[=hplm]{hplm()}}}

\item{digits}{The minimum number of significant digits to be use.
If set to "auto" (default), values are predefined.}

\item{smd}{If TRUE, reports between-case standardized mean differences.}

\item{casewise}{Returns the estimations for each case}

\item{object}{An scdf or an object exported from a scan function.}

\item{caption}{Character string with table caption. If left NA (default) a
caption will be created based on the exported object.}

\item{footnote}{Character string with table footnote. If left NA (default) a
footnote will be created based on the exported object.}

\item{filename}{String containing the file name. If a filename is given the
output will be written to that file.}

\item{kable_styling_options}{list with arguments passed to the kable_styling
function.}

\item{kable_options}{list with arguments passed to the kable function.}

\item{round}{Integer passed to the digits argument internally used to round
values.}

\item{nice}{If set TRUE (default) output values are rounded and optimized for
publication tables.}
}
\value{
\tabular{ll}{
    \tab  \cr
   \code{model} \tab List containing infromation about the applied model. \cr
   \code{N} \tab Number of single-cases. \cr
   \code{formula} \tab A list containing the fixed and the random formulas of the hplm model. \cr
   \code{hplm} \tab Object of class lme contaning the multilevel model. \cr
   \code{model.0} \tab Object of class lme containing the Zero Model. \cr
   \code{ICC} \tab List containing intraclass correlation and test parameters. \cr
   \code{model.without} \tab Object of class gls containing the fixed effect model. \cr
   \code{contrast} \tab List with contrast definitions. \cr
}
}
\description{
The \code{\link[=hplm]{hplm()}} function computes a hierarchical piecewise regression model.
}
\section{Functions}{
\itemize{
\item \code{print(sc_hplm)}: Print results

\item \code{export(sc_hplm)}: Export results as html table (see \code{\link[=export]{export()}})

\item \code{coef(sc_hplm)}: Extract model coefficients

}}
\examples{

## Compute hplm model on a MBD over fifty cases (restricted log-likelihood)
hplm(exampleAB_50, method = "REML", random.slopes = FALSE)

## Analyzing with additional L2 variables
Leidig2018 |>
  add_l2(Leidig2018_l2) |>
  hplm(update.fixed = .~. + gender + migration + ITRF_TOTAL*phaseB,
       slope = FALSE, random.slopes = FALSE, lr.test = FALSE
  )

}
\seealso{
Other regression functions: 
\code{\link{autocorr}()},
\code{\link{corrected_tau}()},
\code{\link{mplm}()},
\code{\link{plm}()},
\code{\link{trend}()}
}
\author{
Juergen Wilbert
}
\concept{regression functions}
