% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trend.R
\name{trend}
\alias{trend}
\title{Trend analysis for single-cases data}
\usage{
trend(
  data,
  dvar,
  pvar,
  mvar,
  offset = "deprecated",
  first_mt = 0,
  model = NULL
)
}
\arguments{
\item{data}{A single-case data frame. See \code{\link[=scdf]{scdf()}} to learn about this
format.}

\item{dvar}{Character string with the name of the dependent variable.
Defaults to the attributes in the scdf file.}

\item{pvar}{Character string with the name of the phase variable. Defaults to
the attributes in the scdf file.}

\item{mvar}{Character string with the name of the measurement time variable.
Defaults to the attributes in the scdf file.}

\item{offset}{(Deprecated. Please use first_mt). An offset for the first
measurement-time of each phase. If \code{offset = 0}, the phase measurement is
handled as MT 1. Default is \code{offset = -1}, setting the first value of MT to
0.}

\item{first_mt}{A numeric setting the value for the first measurement-time.
Default = 0.}

\item{model}{A string or a list of (named) strings each depicting one
regression model. This is a formula expression of the standard R class. The
parameters of the model are \code{values}, \code{mt} and \code{phase}.}
}
\value{
\item{trend}{A matrix containing the results (Intercept, B and beta)
of separate regression models for phase A, phase B, and the whole data.}
\item{first_mt}{Numeric argument from function call (see arguments
section).}
}
\description{
The \code{trend()} function provides an overview of linear trends in single case
data. By default, it provides the intercept and slope of a linear and
quadratic regression of measurement time on scores. Models are calculated
separately for each phase and across all phases. For more advanced use, you
can add regression models using the R-specific formula class.
}
\examples{

## Compute the linear and squared regression for a random single-case
design <- design(slope = 0.5)
matthea <- random_scdf(design)
trend(matthea)

## Besides the linear and squared regression models compute two custom models:
## a) a cubic model, and 
## b) the values predicted by the natural logarithm of the
## measurement time.
design <- design(slope = 0.3)
ben <- random_scdf(design)
trend(
  ben, 
  model = list("Cubic" = values ~ mt^3, "Log Time" = values ~ log(mt)), 
  first_mt = 1 # must be set to 1 because log(0) would be -Inf
)

}
\seealso{
\code{\link[=describe]{describe()}}

Other regression functions: 
\code{\link{autocorr}()},
\code{\link{corrected_tau}()},
\code{\link{hplm}()},
\code{\link{mplm}()},
\code{\link{plm}()}
}
\author{
Juergen Wilbert
}
\concept{regression functions}
