% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scan_zip.R
\name{zip_statistic_factor}
\alias{zip_statistic_factor}
\title{Factor(s) in the product of the EB-ZIP window statistic.}
\usage{
zip_statistic_factor(p, d, mu, y, tol = 1e-08)
}
\arguments{
\item{p}{Numeric vector of excess zero probabilities.}

\item{d}{Numeric vector of estimates of the excess zero indicators. Of same 
length as \code{p}.}

\item{mu}{Numeric vector of given/estimated Poisson expected value 
parameters. Of same length as \code{p}.}

\item{y}{Integer vector of observed counts. Of same length as \code{p}.}

\item{tol}{Scalar; probability p below this is considered equal to zero.}
}
\value{
A numeric vector of same length as input vector \code{p}.
}
\description{
Computes one or more factors in the product of the numerator or denominator
of the EB-ZIP window statistic (i.e. the one calculated for a given 
space-time window W). Should be able to handle cases where p = 0.
}
\keyword{internal}

