% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotCCNetwork.R
\name{plotCCNetwork}
\alias{plotCCNetwork}
\title{Visualize cell cluster association network graph}
\usage{
plotCCNetwork(
  network.data,
  cell_id = NULL,
  cell_cluster = FALSE,
  vertex.colors = NULL,
  vertex.size = 10,
  vertex.label.cex = 0.8,
  vertex.label.dist = 1,
  vertex.label.color = "black",
  edge.width = 5,
  margin = 0,
  layout = layout_with_lgl,
  legend.cex = 1.5,
  legend.pt.cex = 3,
  proportion = 1,
  plotgraph = TRUE
)
}
\arguments{
\item{network.data}{The input network data is the result from the \code{ConNetGNN} function.}

\item{cell_id}{A vector of cell phenotype.}

\item{cell_cluster}{A binary value. Whether to automatically identify cell clusters based on edge betweenness. Default: \code{FALSE}.}

\item{vertex.colors}{The fill color of the vertex. The number of colors should match the number of cell phenotypes. If \code{NULL (default)}, the system will automatically assign colors.}

\item{vertex.size}{The size of the vertex. Default: \code{10}.}

\item{vertex.label.cex}{The font size for vertex labels. Default: \code{0.8}.}

\item{vertex.label.dist}{The distance of the label from the center of the vertex. If it is 0 then the label is centered on the vertex. Default: \code{1}.}

\item{vertex.label.color}{The color of the labels. Default: \code{black}.}

\item{edge.width}{The width of the edge. This does not affect the relative size of the edge weights. Default: \code{5}.}

\item{margin}{The amount of empty space below, over, at the left and right of the plot, it is a numeric
vector of length four. Usually values between 0 and 0.5 are meaningful, but negative values
are also possible, that will make the plot zoom in to a part of the graph. If it is shorter than
four then it is recycled. Default: \code{0}.}

\item{layout}{Either a function or a numeric matrix. It specifies how the vertices will be placed on the plot. For details, please refer to the \code{igraph}Package. Default: \code{layout_with_lgl}.}

\item{legend.cex}{The font size of legend. Default: \code{1.5}.}

\item{legend.pt.cex}{Expansion factor(s) for the points. Default: \code{3}.}

\item{proportion}{This parameter specifies what percentage of edges to display (edges are sorted by their weight in descending order). Default: \code{1}, all edges are used.}

\item{plotgraph}{Whether to draw the picture. Default: \code{TRUE}. If \code{FALSE}, the image will not be displayed but the network data will be returned in the igraph data format.}
}
\value{
Graph or network data.
}
\description{
The \code{plotCCNetwork} function takes cells belonging to the same phenotype as a cluster.
When cell phenotypes are not provided, the \code{plotCCNetwork} functions identify cell clusters based on edge betweenness.
Cell interactions between cell clusters are merged into one edge by mean.
The thickness of the edge indicates the strength of interaction between cell clusters.
}
\details{
plotCCNetwork
}
\examples{
require(igraph)
require(graphics)

data(ConNetGNN_data)

# Construct the cell phenotype vector.
cell_id<-colnames(ConNetGNN_data[["cell_network"]])
temp<-unlist(strsplit(cell_id,"_"))
cell_phen<-temp[seq(2,length(temp)-1,by=3)]
names(cell_id)<-cell_phen
head(cell_id)
plotCCNetwork(ConNetGNN_data,cell_id,edge.width=10)
}
