% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotGANetwork.R
\name{plotGANetwork}
\alias{plotGANetwork}
\title{Visualize gene association network graph of a gene module or pathway at the specified cell phenotype}
\usage{
plotGANetwork(
  network.data,
  cellset,
  geneset,
  rwr.gamma = 0.7,
  vertex.colors = NULL,
  vertex.size = 10,
  vertex.label.cex = 0.8,
  vertex.label.dist = 1,
  vertex.label.color = "black",
  edge.width = 5,
  margin = 0,
  layout = layout_as_star,
  main = NULL,
  plotgraph = TRUE
)
}
\arguments{
\item{network.data}{Network data constructed by the \code{ConNetGNN} function.}

\item{cellset}{A vector of cell id. A cell set corresponding to the specified cell phenotype.}

\item{geneset}{A vector of gene id. A gene module or pathway.}

\item{rwr.gamma}{Restart parameter. Default: \code{0.7}.}

\item{vertex.colors}{he fill color of the vertex. The number of colors should match the number of cell phenotypes. If \code{NULL (default)}, the system will automatically assign colors.}

\item{vertex.size}{The size of the vertex. Default: \code{10}.}

\item{vertex.label.cex}{The font size for vertex labels. Default: \code{0.8}.}

\item{vertex.label.dist}{The distance of the label from the center of the vertex. If it is 0 then the label is centered on the vertex. Default: \code{1}.}

\item{vertex.label.color}{The color of the labels. Default: \code{black}.}

\item{edge.width}{The width of the edge. This does not affect the relative size of the edge weights. Default: \code{5}.}

\item{margin}{The amount of empty space below, over, at the left and right of the plot, it is a numeric
vector of length four. Usually values between 0 and 0.5 are meaningful, but negative values
are also possible, that will make the plot zoom in to a part of the graph. If it is shorter than
four then it is recycled. Default: \code{0}.}

\item{layout}{Either a function or a numeric matrix. It specifies how the vertices will be placed on the plot. For details, please refer to the \code{igraph}Package. Default: \code{layout_as_star}.}

\item{main}{A main title for the plot.}

\item{plotgraph}{Whether to draw the picture. Default: \code{TRUE}. If \code{FALSE}, the image will not be displayed but the network data will be returned in the igraph data format.}
}
\value{
A graph or list.
}
\description{
Based on the gene set input by the user, \code{plotGANetwork} functional draws the gene association network in the specified cell phenotype.
The node size in the network reflects the activation strength of the gene. The thickness of the edge indicates the strength of interaction between genes.
}
\details{
plotGANetwork
}
\examples{
require(igraph)

# Load the result of the ConNetGNN function.
data(ConNetGNN_data)

data("Hv_exp")
index<-grep("0h",colnames(Hv_exp))
cellset<-colnames(Hv_exp)[index]
pathways<-load_path_data(system.file("extdata", "KEGG_human.gmt", package = "scapGNN"))
geneset<-pathways[[which(names(pathways)=="Tight junction [PATH:hsa04530]")]]
plotGANetwork(ConNetGNN_data,cellset,geneset,main = "Tight junction [PATH:hsa04530]")

}
