% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scatterD3.R
\name{scatterD3}
\alias{scatterD3}
\title{Scatter plot HTML widget}
\source{
D3.js was created by Michael Bostock. See \url{http://d3js.org/}
}
\usage{
scatterD3(x, y, data = NULL, lab = NULL, x_log = FALSE, y_log = FALSE,
  point_size = 64, labels_size = 10, labels_positions = NULL,
  point_opacity = 1, hover_size = 1, hover_opacity = NULL,
  fixed = FALSE, col_var = NULL, col_continuous = NULL, colors = NULL,
  ellipses = FALSE, ellipses_level = 0.95, symbol_var = NULL,
  size_var = NULL, size_range = c(10, 300), col_lab = NULL,
  symbol_lab = NULL, size_lab = NULL, key_var = NULL, type_var = NULL,
  opacity_var = NULL, unit_circle = FALSE, url_var = NULL,
  tooltips = TRUE, tooltip_text = NULL, xlab = NULL, ylab = NULL,
  html_id = NULL, width = NULL, height = NULL, legend_width = 150,
  left_margin = 30, xlim = NULL, ylim = NULL,
  dom_id_reset_zoom = "scatterD3-reset-zoom",
  dom_id_svg_export = "scatterD3-svg-export",
  dom_id_lasso_toggle = "scatterD3-lasso-toggle", transitions = FALSE,
  menu = TRUE, lasso = FALSE, lasso_callback = NULL,
  click_callback = NULL, zoom_callback = NULL, lines = data.frame(slope =
  c(0, Inf), intercept = c(0, 0), stroke_dasharray = c(5, 5)),
  axes_font_size = "100\%", legend_font_size = "100\%", caption = NULL)
}
\arguments{
\item{x}{numerical vector of x values, or variable name if data is not NULL}

\item{y}{numerical vector of y values, or variable name if data is not NULL}

\item{data}{default dataset to use for plot.}

\item{lab}{optional character vector of text labels, or variable name if
data is not NULL}

\item{x_log}{if TRUE, set x scale as logarithmic}

\item{y_log}{if TRUE, set y scale as logarithmic}

\item{point_size}{points size. Ignored if size_var is not NULL.}

\item{labels_size}{text labels size}

\item{labels_positions}{A data frame, as created by the
"Export labels positions" menu entry, giving each label x and y
position.}

\item{point_opacity}{points opacity, as an integer (same opacity for all
points) or a vector of integers, or variable name if data is not NULL}

\item{hover_size}{factor for changing size when hovering points}

\item{hover_opacity}{points opacity when hovering}

\item{fixed}{force a 1:1 aspect ratio}

\item{col_var}{optional vector for points color mapping, or variable name
if data is not NULL}

\item{col_continuous}{specify if the color scale must be continuous. By
default, if \code{col_var} is numeric, not a factor, and has more than
6 unique values, it is considered as continuous.}

\item{colors}{vector of custom points colors. Colors must be defined as an
hexadecimal string (eg "#FF0000"). If \code{colors} is a named list or
a named vector, then the colors will be associated with their name
within \code{col_var}. Ignored for a continuous color scale.}

\item{ellipses}{draw confidence ellipses for points or the different color
mapping groups}

\item{ellipses_level}{confidence level for ellipses (0.95 by default)}

\item{symbol_var}{optional vector for points symbol mapping, or variable
name if data is not NULL}

\item{size_var}{optional vector for points size mapping, or variable name
if data is not NULL}

\item{size_range}{numeric vector of length 2, giving the minimum and
maximum point sizes when mapping with size_var}

\item{col_lab}{color legend title}

\item{symbol_lab}{symbols legend title}

\item{size_lab}{size legend title}

\item{key_var}{optional vector of rows ids, or variable name if data is not
NULL. This is passed as a key to d3, and is only added in shiny apps
where displayed rows are filtered interactively.}

\item{type_var}{optional vector of points type : "point" for adot
(default), "arrow" for an arrow starting from the origin.}

\item{opacity_var}{optional vector of points opacity (values between 0 and
1)}

\item{unit_circle}{set tot TRUE to draw a unit circle}

\item{url_var}{optional vector of URLs to be opened when a point is clicked}

\item{tooltips}{logical value to display tooltips when hovering points}

\item{tooltip_text}{optional character vector of tooltips text}

\item{xlab}{x axis label}

\item{ylab}{y axis label.}

\item{html_id}{manually specify an HTML id for the svg root node. A random
one is generated by default.}

\item{width}{figure width, computed when displayed}

\item{height}{figure height, computed when displayed}

\item{legend_width}{legend area width, in pixels. Set to 0 to disable
legend completely.}

\item{left_margin}{margin on the left of the plot, in pixels}

\item{xlim}{numeric vector of length 2, manual x axis limits}

\item{ylim}{numeric vector of length 2, manual y axis limits}

\item{dom_id_reset_zoom}{HTML DOM id of the element to bind the
"reset zoom" control to.}

\item{dom_id_svg_export}{HTML DOM id of the element to bind the
"svg export" control to.}

\item{dom_id_lasso_toggle}{HTML DOM id of the element to bind the
"toggle lasso" control to.}

\item{transitions}{if TRUE, data updates are displayed with smooth
transitions, if FALSE the whole chart is redrawn. Only used within
shiny apps.}

\item{menu}{wether to display the tools menu (gear icon)}

\item{lasso}{logical value to add
{https://github.com/skokenes/D3-Lasso-Plugin}{d3-lasso-plugin} feature}

\item{lasso_callback}{the body of a JavaScript callback function with the
argument \code{sel} to be applied to a lasso plugin selection}

\item{click_callback}{the body of a JavaScript callback function whose
inputs are html_id, and the index of the clicked element.}

\item{zoom_callback}{the body of a JavaScript callback function whose
inputs are the new xmin, xmax, ymin and ymax after a zoom action is
triggered.}

\item{lines}{a data frame with at least the \code{slope} and
\code{intercept} columns, and as many rows as lines to add to
scatterplot. Style can be added with \code{stroke}, \code{stroke_width}
and \code{stroke_dasharray} columns. To draw a vertical line, pass
\code{Inf} as \code{slope} value.}

\item{axes_font_size}{font size for axes text (any CSS compatible value)}

\item{legend_font_size}{font size for legend text (any CSS compatible
value)}

\item{caption}{caption to be displayed when clicking on the corresponding
icon. Either a character string, or a list with title, subtitle and
text elements.}
}
\description{
Generates an interactive scatter plot based on d3.js.
Interactive features include zooming, panning, text labels moving, tooltips,
fading effects in legend. Additional handlers are provided to change label
size, point opacity or export the figure as an SVG file via HTML form controls.
}
\details{
Interactive scatter plots based on htmlwidgets and d3.js
}
\examples{
scatterD3(x = mtcars$wt, y = mtcars$mpg, data=NULL, lab = rownames(mtcars),
          col_var = mtcars$cyl, symbol_var = mtcars$am,
          xlab = "Weight", ylab = "Mpg", col_lab = "Cylinders",
          symbol_lab = "Manual transmission", html_id = NULL)

}
\author{
Julien Barnier <julien.barnier@ens-lyon.fr>
}
