% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{embeddingGroupPlot}
\alias{embeddingGroupPlot}
\title{Plotting function for cluster labels, names contain cell names. Used primarily in embeddingPlot().}
\usage{
embeddingGroupPlot(
  plot.df,
  groups,
  geom_point_w,
  min.cluster.size,
  mark.groups,
  font.size,
  legend.title,
  shuffle.colors,
  palette,
  plot.na,
  ...
)
}
\arguments{
\item{plot.df}{data.frame for plotting. In embeddingPlot(), this is a tibble from tibble::rownames_to_column().}

\item{groups}{vector of cluster labels, names contain cell names (default=NULL)}

\item{geom_point_w}{function to work with geom_point layer from ggplot2 (default=ggplot2::geom_point)}

\item{min.cluster.size}{labels for all groups with number of cells fewer than this parameter are considered as missed (default=0). This argument is ignored if groups aren't provided}

\item{mark.groups}{plot cluster labels above points (default=TRUE)}

\item{font.size}{font size for cluster labels (default=c(3, 7)). It can either be single number for constant font size or pair (min, max) for font size depending on cluster size}

\item{legend.title}{legend title (default=NULL)}

\item{shuffle.colors}{shuffle colors (default=FALSE)}

\item{palette}{function, which accepts number of colors and return list of colors (i.e. see 'colorRampPalette') (default=NULL)}

\item{plot.na}{boolean/numeric Whether to plot points, for which groups / colors are missed (default=is.null(subgroups), i.e. FALSE). If plot.na passed a numeric value below 0, the NA symbols are plotted below the cells. Otherwise if values >=0, they’re plotted above the cells. Note that this argument is FALSE if 'subgroups' is NULL}

\item{...}{Additional arguments passed to ggplot2::geom_label_repel()}
}
\value{
ggplot2 object
}
\description{
Plotting function for cluster labels, names contain cell names. Used primarily in embeddingPlot().
}
