% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocess-function.R
\name{phase_pairs}
\alias{phase_pairs}
\title{Calculate phase-pairs for a unique case}
\usage{
phase_pairs(phase, session = seq_along(phase))
}
\arguments{
\item{phase}{vector of treatment indicators or a character or factor vector indicating unique treatment phases.}

\item{session}{numeric vector of measurement occasions.}
}
\description{
Calculate phase-pairs based on phases and session numbering.
}
\examples{

phases <- rep(c("A","B","A","B"), each = 4)
sessions <- 1:length(phases)

phase_pairs(phases, sessions)

phases <- rep(c("A","B","C","A","B","C","D"), each = 4)
phase_pairs(phases)

phases <- rep(c("B","A","C","B","A","B","C","A"), each = 4)
phase_pairs(phases)

}
