% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/publications.r
\name{get_journalrank}
\alias{get_journalrank}
\title{Get journal ranking.}
\usage{
get_journalrank(journals, max.distance = 0.05)
}
\arguments{
\item{journals}{a character list giving the journal list}

\item{max.distance}{maximum distance allowed for a match between journal and journal list.
Expressed either as integer, or as a fraction of the pattern length times the maximal transformation cost
(will be replaced by the smallest integer not less than the corresponding fraction), or a list with possible components}
}
\value{
Journal ranking data.
}
\description{
Get journal ranking for a journal list.
}
\examples{
\dontrun{
library(scholar)

id <- get_publications("bg0BZ-QAAAAJ&hl")
impact <- get_journalrank(journals=id$journal)

id <- cbind(id, impact)
}
}
\author{
Dominique Makowski and Guangchuang Yu
}
