% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregate_list.R
\name{step_aggregate_list}
\alias{step_aggregate_list}
\alias{tidy.step_aggregate_list}
\title{Feature aggregation step based on a defined list}
\usage{
step_aggregate_list(
  recipe,
  ...,
  role = "predictor",
  trained = FALSE,
  list_agg = NULL,
  fun_agg = NULL,
  others = "discard",
  name_others = "others",
  res = NULL,
  prefix = "agg_",
  keep_original_cols = FALSE,
  skip = FALSE,
  id = rand_id("aggregate_list")
)

\method{tidy}{step_aggregate_list}(x, ...)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the sequence of
operations for this recipe.}

\item{...}{One or more selector functions to choose variables
for this step. See \code{\link[=selections]{selections()}} for more details.}

\item{role}{For model terms created by this step, what analysis role should
they be assigned? By default, the new columns created by this step from
the original variables will be used as \code{predictors} in a model.}

\item{trained}{A logical to indicate if the quantities for preprocessing
have been estimated.}

\item{list_agg}{Named list of aggregated variables.}

\item{fun_agg}{Aggregation function like \code{sum} or \code{mean}.}

\item{others}{Behavior for the selected variables in \code{...} that are not
present in \code{list_agg}. If \code{discard} (the default), they are not kept.
If \code{asis}, they are kept without modification. If \code{aggregate}, they are
aggregated in a new variable.}

\item{name_others}{If \code{others} is set to \code{aggregate}, name of the
aggregated variable. Not used otherwise.}

\item{res}{This parameter is only produced after the recipe has been trained.}

\item{prefix}{A character string for the prefix of the resulting new
variables that are not named in \code{list_agg}.}

\item{keep_original_cols}{A logical to keep the original variables in
the output. Defaults to \code{FALSE}.}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by \code{\link[=bake]{bake()}}? While all operations are baked
when \code{\link[=prep]{prep()}} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = TRUE} as it may affect
the computations for subsequent operations.}

\item{id}{A character string that is unique to this step to identify it.}

\item{x}{A \code{step_aggregate_list} object.}
}
\value{
An updated version of recipe with the new step added to the
sequence of any existing operations.
}
\description{
Aggregate variables according to prior knowledge.
}
\examples{
list_iris <- list(sepal.size = c("Sepal.Length", "Sepal.Width"),
                  petal.size = c("Petal.Length", "Petal.Width"))
rec <-
  iris \%>\%
  recipe(formula = Species ~ .) \%>\%
  step_aggregate_list(all_numeric_predictors(),
                      list_agg = list_iris, fun_agg = prod) \%>\%
  prep()
rec
tidy(rec, 1)
bake(rec, new_data = NULL)
}
\author{
Antoine Bichat
}
