% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rownormalize_tss.R
\name{step_rownormalize_tss}
\alias{step_rownormalize_tss}
\alias{tidy.step_rownormalize_tss}
\title{Feature normalization step using total sum scaling}
\usage{
step_rownormalize_tss(
  recipe,
  ...,
  role = NA,
  trained = FALSE,
  res = NULL,
  skip = FALSE,
  id = rand_id("rownormalize_tss")
)

\method{tidy}{step_rownormalize_tss}(x, ...)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the sequence of
operations for this recipe.}

\item{...}{One or more selector functions to choose variables
for this step. See \code{\link[=selections]{selections()}} for more details.}

\item{role}{Not used by this step since no new variables are created.}

\item{trained}{A logical to indicate if the quantities for preprocessing
have been estimated.}

\item{res}{This parameter is only produced after the recipe has been trained.}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by \code{\link[=bake]{bake()}}? While all operations are baked
when \code{\link[=prep]{prep()}} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = TRUE} as it may affect
the computations for subsequent operations.}

\item{id}{A character string that is unique to this step to identify it.}

\item{x}{A \code{step_rownormalize_tss} object.}
}
\value{
An updated version of recipe with the new step added to the
sequence of any existing operations.
}
\description{
Normalize a set of variables by converting them to proportion, making
them sum to 1. Also known as simplex projection.
}
\examples{
rec <-
  recipe(Species ~ ., data = iris) \%>\%
  step_rownormalize_tss(all_numeric_predictors()) \%>\%
  prep()
rec
tidy(rec, 1)
bake(rec, new_data = NULL)
}
\author{
Antoine Bichat
}
