% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/data_manipulation.R
\name{filterData}
\alias{filterData}
\title{Expression based row filtering}
\usage{
filterData(data, condition = "TRUE", remove.cols = NULL)
}
\arguments{
\item{data}{A NAMED matrix or data frame to be filtered (column names are required).}

\item{condition}{A string indicating the condition that the row have to fulfill to be retained. The column names are used as variables in the condition (see examples bellow).}

\item{remove.cols}{Either a vector of column names or a vector of column indices to be removed from the result}
}
\value{
The original data where the rows for which the condition is \code{FALSE} and the columns in the vector \code{remove.cols}  have been removed
}
\description{
This is a simple function to filter data based on an expression defined using the colum names
}
\examples{
data(data_gh_2008)
names(data.gh.2008)
filterData(data.gh.2008, condition="CN2 > 0.7 & Kernel < 0.7", remove.cols=1:2)
}
\seealso{
\code{\link{summarizeData}}, \code{\link{writeTabular}} and the vignette \code{vignette(topic="Data_loading_and_manipulation",
package="scmamp")}
}

