% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scorecard.R
\name{scorecard}
\alias{scorecard}
\title{Creating a Scorecard}
\usage{
scorecard(bins, model, points0 = 600, odds0 = 1/19, pdo = 50,
  basepoints_eq0 = FALSE)
}
\arguments{
\item{bins}{Binning information generated from \code{woebin} function.}

\item{model}{A glm model object.}

\item{points0}{Target points, default 600.}

\item{odds0}{Target odds, default 1/19. Odds = p/(1-p).}

\item{pdo}{Points to Double the Odds, default 50.}

\item{basepoints_eq0}{Logical, default FALSE. If it is TRUE, the basepoints equals 0 and will equally add to variables' points.}
}
\value{
scorecard
}
\description{
\code{scorecard} creates a scorecard based on the results from \code{woebin} and \code{glm}.
}
\examples{
library(data.table)
library(scorecard)

# load germancredit data
data("germancredit")

# select only 5 x variables and rename creditability as y
dt = setDT(germancredit)[, c(1:5, 21)][, `:=`(
  y = ifelse(creditability == "bad", 1, 0),
  creditability = NULL
)]

# woe binning ------
bins = woebin(dt, "y")
dt_woe = woebin_ply(dt, bins)

# glm ------
m = glm( y ~ ., family = "binomial", data = dt_woe)
# summary(m)

\dontrun{
# Select a formula-based model by AIC
m_step = step(m, direction="both", trace=FALSE)
m = eval(m_step$call)
# summary(m)

# predicted proability
# dt_woe$pred = predict(m, type='response', dt_woe)

# performace
# ks & roc plot
# perf_eva(dt_woe$y, dt_woe$pred)
}

# scorecard
# Example I # creat a scorecard
card = scorecard(bins, m)

\dontrun{
# credit score
# Example I # only total score
score1 = scorecard_ply(dt, card)

# Example II # credit score for both total and each variable
score2 = scorecard_ply(dt, card, only_total_score = F)
}
}
\seealso{
\code{\link{scorecard_ply}}
}
