% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppi_cW.R
\name{ppi_cW}
\alias{ppi_cW}
\alias{ppi_cW_auto}
\title{Quickly Generate a Vector of Windham Exponents for the PPI Model}
\usage{
ppi_cW(cW, ...)

ppi_cW_auto(cW, Y)
}
\arguments{
\item{cW}{The value of the non-zero Windham tuning exponents.}

\item{...}{Values of \code{TRUE} or \code{FALSE} in the same order of the components specifying that a component has probability mass concentrated near zero.}

\item{Y}{A matrix of observations}
}
\value{
A vector of the same length as the parameter vector of the PPI model. Elements of \eqn{A_L}{A_L} will have a value of \code{cW} if both their row and column component has probability mass concentrated near zero. Similarly, elements of \eqn{b_L} will have a value of \code{cW} if their row corresponds to a component that has a probability mass concentrated near zero. All other elements are zero.
}
\description{
These functions help to quickly generate a set of Windham exponents for use in \code{\link[=ppi_robust]{ppi_robust()}} or \code{\link[=Windham]{Windham()}}.
Rows and columns of \eqn{A_L} and \eqn{b_L} corresponding to components with strong concentrations of probability mass near zero have non-zero constant tuning exponent, and all other elements have a tuning constant of zero.
All elements of \eqn{\beta} have a tuning exponent of zero.

The function \code{ppi_cW_auto()} automatically detects concentrations near zero by fitting a PPI distribution with \eqn{A_L=0} and \eqn{b_L=0} (i.e. a Dirichlet distribution) with the centred log-ratio transformation of the manifold.
}
\details{
The Windham robustifying method involves weighting observations by a function of the proposed model density \insertCite{windham1995ro}{scorematchingad}.
\insertCite{scealy2024ro;textual}{scorematchingad} found that only some of the tuning constants should be non-zero:
the tuning exponents corresponding to \eqn{\beta} should be zero to avoid infinite weights;and to improve efficiency any rows or columns of \eqn{A_L} corresponding to components without concentrations of probability mass (i.e. outliers can't exist) should have exponents of zero.
\insertCite{scealy2024ro;textual}{scorematchingad} set the remaining tuning exponents to a constant.
}
\examples{
Y <- rppi_egmodel(100)$sample
ppi_cW_auto(0.01, Y)
ppi_cW(0.01, TRUE, TRUE, FALSE)
}
\references{
\insertAllCited{}
}
