% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppi_sqrt_multestimator.R
\name{ppi_mmmm}
\alias{ppi_mmmm}
\title{A PPI Score-Matching Marginal Moment Matching Estimator (dimension=3 only)}
\usage{
ppi_mmmm(Y, ni, beta0, w = rep(1, nrow(Y)))
}
\arguments{
\item{Y}{Count data, each row is a multivariate observation.}

\item{ni}{The total for each sample (sum across rows)}

\item{beta0}{\eqn{\beta=\beta_0}{beta=beta0} is the same for each component.}

\item{w}{Weights for each observation. Useful for weighted estimation in \code{\link[=Windham]{Windham()}}.}
}
\value{
A vector of estimates for \eqn{A_L} entries (diagonal and off diagonal).
}
\description{
Computes a marginal moment matching estimator \insertCite{@Section 6.2, @scealy2023sc}{scorematchingad}, which assumes \eqn{\beta} is a known vector with the same value in each element, and \eqn{b_L = 0}.
Only \eqn{A_L} is estimated.
}
\details{
\eqn{\beta=\beta_0} is fixed and not estimated. \eqn{b_L} is fixed at zero.
See \insertCite{@Section 6.2 and A.8 of @scealy2023sc}{scorematchingad}.
The boundary weight function in the score matching discrepancy is the unthresholded product weight function
\deqn{h(z)^2 = \min\left(\prod_{j=1}^{p} z_j^2, a_c^2\right).}{h(z)^2 = min(z1^2 * z2^2 * ... * zp^2).}
}
\references{
\insertAllCited{}
}
