#' Binary Example Data
#'
#' A toy dataset for a probability forecast of a binary outcome variable
#'
#' @format A data.table with 120 rows and 5 variables:
#' \describe{
#'   \item{id}{unique identifier for true observed values}
#'   \item{true_value}{true observed values}
#'   \item{model}{name of the model that generated the forecasts}
#'   \item{horizon}{forecast horzin (e.g. 1 day ahead forecast)}
#'   \item{prediction}{predicted probability that the corresponding true
#'   value will be 1}
#' }

"binary_example_data"


#' Continuous Example Data
#'
#' A toy dataset for a probabilistic forecast of a continuous outcome variable
#'
#' @format A data frame with 6000 rows and 6 variables:
#' \describe{
#'   \item{id}{unique identifier for true observed values}
#'   \item{model}{name of the model that generated the forecasts}
#'   \item{horizon}{forecast horzin (e.g. 1 day ahead forecast)}
#'   \item{true_value}{true observed values}
#'   \item{sample}{number that identifies the predictive sample generated by
#'   a specific model for a specific observed value}
#'   \item{prediction}{predictive sample for the corresponding true
#'   value}
#' }
"continuous_example_data"


#' Integer Example Data
#'
#' A toy dataset for a probabilistic forecast of an integer outcome variable
#'
#' @format A data frame with 6000 rows and 5 variables:
#' \describe{
#'   \item{id}{unique identifier for true observed values}
#'   \item{model}{name of the model that generated the forecasts}
#'   \item{horizon}{forecast horzin (e.g. 1 day ahead forecast)}
#'   \item{true_value}{true observed values}
#'   \item{sample}{number that identifies the predictive sample generated by
#'   a specific model for a specific observed value}
#'   \item{prediction}{predictive sample for the corresponding true
#'   value}
#' }
"integer_example_data"

#' Quantile Example Data - Wide Format
#'
#' A toy dataset for quantile forecasts of an outcome variable
#'
#' @format A data frame with 120 rows and 10 variables:
#' \describe{
#'   \item{true_value}{true observed values}
#'   \item{id}{unique identifier for true observed values}
#'   \item{model}{name of the model that generated the forecasts}
#'   \item{horizon}{forecast horzin (e.g. 1 day ahead forecast)}
#'   \item{lower_90}{prediction for the lower value of the 90\% interval range
#'   (corresponding to the 5\% quantile)}
#'   \item{lower_50}{prediction for the lower value of the 50\% interval range
#'   (corresponding to the 25\% quantile)}
#'   \item{lower_0}{prediction for the lower value of the 0\% interval range
#'   (corresponding to the 50\% quantile, i.e. the median. For computational
#'   reasons there need be a column with \code{lower_0} and \code{upper_0})}
#'   \item{upper_0}{prediction for the upper value of the 0% interval range
#'   (corresponding to the 50\% quantile, i.e. the median)}
#'   \item{upper_50}{prediction for the upper value of the 50\% interval range
#'   (corresponding to the 75\% quantile)}
#'   \item{upper_90}{prediction for the lower value of the 90\% interval range
#'   (corresponding to the 95\% quantile)}
#' }
"quantile_example_data_wide"


#' Quantile Example Data - Long Format
#'
#' A toy dataset for quantile forecasts of an outcome variable
#'
#' @format A data frame with 720 rows and 7 variables:
#' \describe{
#'   \item{true_value}{true observed values}
#'   \item{id}{unique identifier for true observed values}
#'   \item{horizon}{forecast horizon (e.g. 1 day ahead forecast)}
#'   \item{model}{name of the model that generated the forecasts}
#'   \item{prediction}{quantile predictions}
#'   \item{boundary}{lower or upper bound of an interval range}
#'   \item{range}{interval range for which the quantile forecast was made}
#' }
"quantile_example_data_long"


#' Quantile Example Data - Plain Quantile Format
#'
#' A toy dataset for quantile forecasts of an outcome variable in a format
#' that uses plain quantiles instead of interval ranges
#'
#' @format A data frame with 600 rows and 6 variables:
#' \describe{
#'   \item{true_value}{true observed values}
#'   \item{id}{unique identifier for true observed values}
#'   \item{horizon}{forecast horzin (e.g. 1 day ahead forecast)}
#'   \item{model}{name of the model that generated the forecasts}
#'   \item{prediction}{quantile predictions}
#'   \item{quantile}{quantile of the corresponding prediction}
#' }
"quantile_example_data_plain"
