% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{correlation_plot}
\alias{correlation_plot}
\title{Plot Correlation Between Metrics}
\usage{
correlation_plot(scores, select_metrics = NULL)
}
\arguments{
\item{scores}{A data.frame of scores as produced by
\code{\link{eval_forecasts}}}

\item{select_metrics}{A character vector with the metrics to show. If set to
\code{NULL} (default), all metrics present in \code{summarised_scores} will
be shown}
}
\value{
A ggplot2 object showing a coloured matrix of correlations
between metrics
}
\description{
Plots a coloured table of scores obtained using
\code{\link{eval_forecasts}}
}
\examples{
scores <- scoringutils::eval_forecasts(scoringutils::quantile_example_data)
scoringutils::correlation_plot(scores)
}
