% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairwise-comparisons.R
\name{pairwise_comparison}
\alias{pairwise_comparison}
\title{Do Pairwise Comparisons of Scores}
\usage{
pairwise_comparison(
  scores,
  by = c("model"),
  metric = "auto",
  baseline = NULL,
  ...
)
}
\arguments{
\item{scores}{A data.table of scores as produced by \code{\link[=score]{score()}}.}

\item{by}{character vector with names of columns present in the input
data.frame. \code{by} determines how pairwise comparisons will be computed.
You will get a relative skill score for every grouping level determined in
\code{by}. If, for example, \code{by = c("model", "location")}. Then you will get a
separate relative skill score for every model in every location. Internally,
the data.frame will be split according \code{by} (but removing "model" before
splitting) and the pairwise comparisons will be computed separately for the
split data.frames.}

\item{metric}{A character vector of length one with the metric to do the
comparison on. The default is "auto", meaning that either "interval_score",
"crps", or "brier_score" will be selected where available.
See \code{\link[=available_metrics]{available_metrics()}} for available metrics.}

\item{baseline}{character vector of length one that denotes the baseline
model against which to compare other models.}

\item{...}{additional arguments for the comparison between two models. See
\code{\link[=compare_two_models]{compare_two_models()}} for more information.}
}
\value{
A ggplot2 object with a coloured table of summarised scores
}
\description{
Make pairwise comparisons between models. The code for the pairwise
comparisons is inspired by an implementation by Johannes Bracher.

The implementation of the permutation test follows the function
\code{permutationTest} from the \code{surveillance} package by Michael Höhle,
Andrea Riebler and Michaela Paul.
}
\examples{
df <- data.frame(
  model = rep(c("model1", "model2", "model3"), each = 10),
  date = as.Date("2020-01-01") + rep(1:5, each = 2),
  location = c(1, 2),
  interval_score = (abs(rnorm(30))),
  ae_median = (abs(rnorm(30)))
)

res <- pairwise_comparison(df,
  baseline = "model1"
)
plot_pairwise_comparison(res)

eval <- score(example_quantile)
pairwise_comparison(eval, by = c("model"))
}
\author{
Nikos Bosse \email{nikosbosse@gmail.com}

Johannes Bracher, \email{johannes.bracher@kit.edu}
}
\keyword{scoring}
