% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics_point_forecasts.R
\name{squared_error}
\alias{squared_error}
\title{Squared Error}
\usage{
squared_error(true_values, predictions)
}
\arguments{
\item{true_values}{A vector with the true observed values of size n}

\item{predictions}{A vector with predicted values of size n}
}
\value{
vector with the scoring values
}
\description{
Squared Error SE calculated as

\deqn{
  (\textrm{true\_values} - \textrm{predicted\_values})^2
}{
  (true_values - predicted_values)^2
}
}
\examples{
true_values <- rnorm(30, mean = 1:30)
predicted_values <- rnorm(30, mean = 1:30)
squared_error(true_values, predicted_values)
}
\keyword{metric}
