% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-coverage.R
\name{get_coverage}
\alias{get_coverage}
\title{Get quantile and interval coverage values for quantile-based forecasts}
\usage{
get_coverage(forecast, by = "model")
}
\arguments{
\item{forecast}{A forecast object (a validated data.table with predicted and
observed values).}

\item{by}{character vector that denotes the level of grouping for which the
coverage values should be computed. By default (\code{"model"}), one coverage
value per model will be returned.}
}
\value{
A data.table with columns as specified in \code{by} and additional
columns for the coverage values described above

a data.table with columns "interval_coverage",
"interval_coverage_deviation", "quantile_coverage",
"quantile_coverage_deviation" and the columns specified in \code{by}.
}
\description{
For a validated forecast object in a quantile-based format
(see \code{\link[=as_forecast_quantile]{as_forecast_quantile()}} for more information), this function computes:
\itemize{
\item interval coverage of central prediction intervals
\item quantile coverage for predictive quantiles
\item the deviation between desired and actual coverage (both for interval and
quantile coverage)
}

Coverage values are computed for a specific level of grouping, as specified
in the \code{by} argument. By default, coverage values are computed per model.

\strong{Interval coverage}

Interval coverage for a given interval range is defined as the proportion of
observations that fall within the corresponding central prediction intervals.
Central prediction intervals are symmetric around the median and formed
by two quantiles that denote the lower and upper bound. For example, the 50\%
central prediction interval is the interval between the 0.25 and 0.75
quantiles of the predictive distribution.

\strong{Quantile coverage}

Quantile coverage for a given quantile level is defined as the proportion of
observed values that are smaller than the corresponding predictive quantile.
For example, the 0.5 quantile coverage is the proportion of observed values
that are smaller than the 0.5 quantile of the predictive distribution.
Just as above, for a single observation and the quantile of a single
predictive distribution, the value will either be \code{TRUE} or \code{FALSE}.

\strong{Coverage deviation}

The coverage deviation is the difference between the desired coverage
(can be either interval or quantile coverage) and the
actual coverage. For example, if the desired coverage is 90\% and the actual
coverage is 80\%, the coverage deviation is -0.1.
}
\examples{
library(magrittr) # pipe operator
example_quantile \%>\%
  as_forecast_quantile() \%>\%
  get_coverage(by = "model")
}
\keyword{scoring}
