# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Simulate the evolution of biological sequences
#'
#' This function provides an interface for calling \emph{scrm} from R.
#' The command line options are passed via the \code{args} argument.
#' The vignette 'scrm-Arguments' contains details about the available options.
#' Summary statistics are converted into an R format. Additionally, there
#' is an option to write the original command line output into a file.
#'
#' @section Seeding:
#' The R version of scrm uses random number from R's random generator.
#' Therefore, the '-seed' argument of the command-line version will be ignored,
#' and no seed is given in the output.
#' Use the R function \code{\link{set.seed}} prior to calling this
#' function to ensure reproducibility of results.
#'
#' @param args A string containing the command-line arguments for scrm. Look at
#'             scrms vignette for a description of available arguments.
#' @param file If provided, scrm will additionally write it is output into
#'             a file with the given file, using an ms-like text output.
#' @return A named list of summary statistics. Most summary statistics are
#'         again a list, where each entry contains the value for one locus.
#'         For the site frequency spectrum, the summary statistic is a matrix,
#'         where each row contains the spectrum for one locus.
#' @export
#' @keywords datagen
#' @seealso
#' \itemize{
#'   \item \code{vignette('scrm-Arguments')} for an overview of command line arguments and
#'   \item \code{vignette('scrm-TreesForApe')} for an example on using
#'         genealogies simulated with \emph{scrm} with package 'ape'.
#' }
#' @examples
#' set.seed(789)
#' # 5 Chromosomes with 100 bases each with recombination and mutation
#' sum_stats <- scrm('5 1 -r 3.1 100 -t 1.5 -T -L')
#' str(sum_stats)
#'
#' # Simulate the site frequency spectrum at 3 loci. For each locus
#' # 10 Chromosomes of 1Mb length are sampled from two populations with
#' # migration inbetween.
#' scrm('10 3 -r 400 1000000 -l 100000 -I 2 4 6 0.5 -t 300 -oSFS')$sfs
#'
scrm <- function(args, file = "") {
    .Call('_scrm_scrm', PACKAGE = 'scrm', args, file)
}

test_RRG_sample <- function() {
    .Call('_scrm_test_RRG_sample', PACKAGE = 'scrm')
}

test_RRG_sampleUnitExpo <- function() {
    .Call('_scrm_test_RRG_sampleUnitExpo', PACKAGE = 'scrm')
}

test_RRG_sampleExpoExpoLimit <- function(lambda, b, limit) {
    .Call('_scrm_test_RRG_sampleExpoExpoLimit', PACKAGE = 'scrm', lambda, b, limit)
}

