% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_sdPrior.r
\name{papprox_unif}
\alias{papprox_unif}
\title{Compute Cumulative Distribution Function of Approximated (Differentiably) Uniform Distribution.}
\usage{
papprox_unif(x, scale, tildec = 13.86294)
}
\arguments{
\item{x}{denotes the argument of cumulative distribution function}

\item{scale}{the scale parameter originally defining the upper bound of the uniform distribution.}

\item{tildec}{denotes the ratio between scale parameter \eqn{\theta} and \eqn{s}. The latter is responsible for the closeness of
the approximation to the uniform distribution. See also below for further details and the default value.}
}
\value{
the cumulative distribution function.
}
\description{
Compute Cumulative Distribution Function of Approximated (Differentiably) Uniform Distribution.
}
\details{
The cumulative distribution function of \code{\link{dapprox_unif}} is given by
         \deqn{(1/(log(1+exp(-\tilde{c}))+\tilde{c}))*(\tilde{c}*(\tau^2)^(1/2)/\theta-log(exp((\tau^2)^(1/2)*\tilde{c}/\theta)+exp(\tilde{c})))}
			\eqn{\tilde{c}} is chosen such that \eqn{P(\tau^2<=\theta)>=0.95}.
}
\references{
Nadja Klein and Thomas Kneib (2015). Scale-Dependent Priors for Variance Parameters in Structured Additive Distributional Regression. 
\emph{Working Paper}.
}
\seealso{
\code{\link{rapprox_unif}},\code{\link{dapprox_unif}}
}
\author{
Nadja Klein
}
