% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hier_convert.R
\name{hier_convert}
\alias{hier_convert}
\title{Converts hierarchies into different formats}
\usage{
hier_convert(tree, as = "df")
}
\arguments{
\item{tree}{a (nested) hierarchy created using \code{\link{hier_create}}
or modified using \code{\link{hier_add}}, \code{\link{hier_delete}}
or \code{\link{hier_rename}}.}

\item{as}{(character) specifying the export format. Possible choices are:
\itemize{
\item \strong{"df"}: a \code{data.frame} with two columns. The first
columns contains a string containing as many \code{@} as the level of the
node in the string (e.g \code{@} corresponds to the overall
total while \code{@} would be all codes contributing to the total.
The second column contains the names of the levels.
\item \strong{"dt"}: like the \code{df}-version but this result is
converted to a \code{data.table}
\item \strong{"argus"}: used to create hrc-files suitable for tau-argus
\item \strong{"json"}: json format suitable e.g. as input for
the shinyTree package.
\item \strong{"code"}: code required to generate the hierarchy
\item \strong{"sdc"}: a \code{list} which is a suitable input
for \code{sdcTable}
}}
}
\description{
This functions allows to convert nested hierarchies into
other data structures.
}
\examples{
h <- hier_create(root = "Total", nodes = LETTERS[1:2])
h <- hier_add(h, root = "A", nodes = c("a1", "a2"))
h <- hier_add(h, root = "B", nodes = c("b1", "b2"))
h <- hier_add(h, root = "b1", nodes = "b1a")
hier_display(h)

# required code to build the hierarchy
hier_convert(h, as = "code")

# data.frame
hier_convert(h, as = "df")
}
