% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sdc_descriptives.R
\name{sdc_descriptives}
\alias{sdc_descriptives}
\title{Disclosure control for descriptive statistics}
\usage{
sdc_descriptives(
  data,
  id_var = getOption("sdc.id_var"),
  val_var = NULL,
  by = NULL,
  zero_as_NA = NULL
)
}
\arguments{
\item{data}{\link{data.frame} from which the descriptive statistics are
calculated.}

\item{id_var}{\link{character} The name of the id variable. Defaults to \code{ getOption("sdc.id_var")} so that you can provide \code{options(sdc.id_var = "my_id_var")} at the top of your script.}

\item{val_var}{\link{character} vector of value variables on which descriptive
statistics are computed.}

\item{by}{\link{character} vector of grouping variables.}

\item{zero_as_NA}{\link{logical} If TRUE, zeros in 'val_var' are treated as NA.}
}
\value{
A \link{list} of class \code{sdc_descriptives} with detailed information about
options, settings, and compliance with the criteria distinct entities and
dominance.
}
\description{
Checks if your descriptive statistics comply to statistical
disclosure control. Checks for number of distinct entities and dominance.
}
\examples{
sdc_descriptives(
  data = sdc_descriptives_DT,
  id_var = "id",
  val_var = "val_1"
)

sdc_descriptives(
  data = sdc_descriptives_DT,
  id_var = "id",
  val_var = "val_1",
  by = "sector"
)

sdc_descriptives(
  data = sdc_descriptives_DT,
  id_var = "id",
  val_var = "val_1",
  by = c("sector", "year")
)

sdc_descriptives(
  data = sdc_descriptives_DT,
  id_var = "id",
  val_var = "val_2",
  by = c("sector", "year")
)

sdc_descriptives(
  data = sdc_descriptives_DT,
  id_var = "id",
  val_var = "val_2",
  by = c("sector", "year"),
  zero_as_NA = FALSE
)
}
