% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/topBotCoding.R
\docType{methods}
\name{topBotCoding}
\alias{topBotCoding}
\alias{topBotCoding,ANY-method}
\alias{topBotCoding,sdcMicroObj-method}
\alias{topBotCoding-methods}
\title{Top and Bottom Coding}
\usage{
topBotCoding(obj, value, replacement, kind = "top", column = NULL)
}
\arguments{
\item{obj}{vector or one-dimensional matrix or data.frame or object of class
\code{\link{sdcMicroObj-class}}}

\item{value}{limit, from where it should be top- or bottom-coded}

\item{replacement}{replacement value.}

\item{kind}{top or bottom}

\item{column}{xxx}
}
\value{
Top or bottom coded data or modified \code{\link{sdcMicroObj-class}}.
}
\description{
Function for Top and Bottom Coding.
}
\details{
Extreme values are replaced by one value to reduce the disclosure risk.
}
\section{Methods}{
 \describe{
\item{list("signature(obj = \"ANY\")")}{}
\item{list("signature(obj = \"sdcMicroObj\")")}{}}
}
\examples{
data(free1)
topBotCoding(free1[,"DEBTS"], value=9000, replacement=9100, kind="top")

## for objects of class sdcMicro:
data(testdata2)
sdc <- createSdcObj(testdata2, keyVars=c('urbrur','roof','walls','water','electcon','relat','sex'),
           numVars=c('expend','income','savings'), w='sampling_weight')
sdc <- topBotCoding(sdc, value=500000, replacement=1000, column="income")
testdataout <- extractManipData(sdc)
}
\author{
Matthias Templ
}
\seealso{
\code{\link{indivRisk}}
}
\keyword{manip}

