% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addGhostVars.R
\docType{methods}
\name{addGhostVars}
\alias{addGhostVars}
\title{addGhostVars}
\usage{
addGhostVars(obj, keyVar, ghostVars)
}
\arguments{
\item{obj}{an object of class \code{\link{sdcMicroObj-class}}}

\item{keyVar}{character-vector of length 1 refering to a categorical key variable within \code{obj}.}

\item{ghostVars}{a character vector specifying variables that are linked to \code{keyVar}. Variables listed here must not be be listed in either slots
\code{@keyVars}, \code{@numVars}, \code{@pramVars}, \code{@weightVar}, \code{@hhId} or \code{@strataVar} in \code{obj}.}
}
\value{
a modified \code{\link{sdcMicroObj-class}} object.
}
\description{
specify variables that are \code{linked} to a key variable. This results in all
suppressions of the key-variable being also applied on the corresponding 'ghost'-variables.
}
\examples{
data(testdata2)
sdc <- createSdcObj(testdata2,
  keyVars=c('urbrur','roof','walls','water','electcon','relat','sex'),
  numVars=c('expend','income','savings'), w='sampling_weight')
## we want to link the anonymization status of key variabe 'urbrur' to 'hhcivil'
sdc <- addGhostVars(sdc, keyVar="urbrur", ghostVars=c("hhcivil"))
## we want to link the anonymization status of key variabe 'roof' to 'represent'
sdc <- addGhostVars(sdc, keyVar="roof", ghostVars=c("represent"))
}
\author{
Bernhard Meindl
}
\keyword{manip}

