% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.r
\name{set.sdcMicroObj}
\alias{set.sdcMicroObj}
\title{set.sdcMicroObj}
\usage{
set.sdcMicroObj(object, type, input)
}
\arguments{
\item{object}{a \code{\link{sdcMicroObj-class}}-object}

\item{type}{a character vector of length 1 defining what to calculate|return|modify. Allowed types are listed below
and the slot with the corresponding name will be replaced by the content of \code{input.}
\itemize{
\item \code{origData: }
\item \code{keyVars: }
\item \code{pramVars: }
\item \code{numVars: }
\item \code{weightVar: }
\item \code{hhId: }
\item \code{strataVar: }
\item \code{sensibleVar: }
\item \code{manipPramVars: }
\item \code{manipNumVars: }
\item \code{manipGhostVars: }
\item \code{manipStrataVar: }
\item \code{risk: }
\item \code{utility: }
\item \code{pram: }
\item \code{localSuppression: }
\item \code{options: }
\item \code{prev: }
\item \code{set: }
\item \code{additionalResults: }
\item \code{deletedVars: }}}

\item{input}{a list depending on argument \code{type}. The content of the list must
match the allowed data-type of the slot in the \code{\link{sdcMicroObj-class}}-object
that should be replaced.}
}
\value{
a \code{\link{sdcMicroObj-class}}-object
}
\description{
modify \code{\link{sdcMicroObj-class}}-objects depending on argument \code{type}
}
\examples{
sdc <- createSdcObj(testdata2,
  keyVars=c('urbrur','roof','walls','water','electcon','relat','sex'),
  numVars=c('expend','income','savings'), w='sampling_weight')
ind_pram <- match(c("sex"), colnames(testdata2))
get.sdcMicroObj(sdc, type="pramVars")
sdc <- set.sdcMicroObj(sdc, type="pramVars", input=list(ind_pram))
get.sdcMicroObj(sdc, type="pramVars")
}
